/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.custom.IntOrString;
import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V1TCPSocketAction;
import io.kubernetes.client.openapi.models.V1TCPSocketActionFluent;
import java.util.Objects;

public class V1TCPSocketActionFluentImpl<A extends V1TCPSocketActionFluent<A>>
extends BaseFluent<A>
implements V1TCPSocketActionFluent<A> {
    private String host;
    private IntOrString port;

    public V1TCPSocketActionFluentImpl() {
    }

    public V1TCPSocketActionFluentImpl(V1TCPSocketAction instance) {
        if (instance != null) {
            this.withHost(instance.getHost());
            this.withPort(instance.getPort());
        }
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public A withHost(String host) {
        this.host = host;
        return (A)this;
    }

    @Override
    public Boolean hasHost() {
        return this.host != null;
    }

    @Override
    public IntOrString getPort() {
        return this.port;
    }

    @Override
    public A withPort(IntOrString port) {
        this.port = port;
        return (A)this;
    }

    @Override
    public Boolean hasPort() {
        return this.port != null;
    }

    @Override
    public A withNewPort(int value) {
        return this.withPort(new IntOrString(value));
    }

    @Override
    public A withNewPort(String value) {
        return this.withPort(new IntOrString(value));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1TCPSocketActionFluentImpl that = (V1TCPSocketActionFluentImpl)o;
        if (!Objects.equals(this.host, that.host)) {
            return false;
        }
        return Objects.equals(this.port, that.port);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.host, this.port, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host + ",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port);
        }
        sb.append("}");
        return sb.toString();
    }
}

