/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.theta;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.datasketches.theta.SketchHolder;
import org.apache.druid.query.aggregation.datasketches.theta.SketchModule;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnType;

public class SketchConstantPostAggregator
implements PostAggregator {
    private final String name;
    private final String value;
    private final SketchHolder sketchValue;

    @JsonCreator
    public SketchConstantPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="value") String value) {
        this.name = name;
        Preconditions.checkArgument((value != null && !value.isEmpty() ? 1 : 0) != 0, (Object)"Constant value cannot be null or empty, expecting base64 encoded sketch string");
        this.value = value;
        this.sketchValue = SketchHolder.deserializeSafe(value);
    }

    public Set<String> getDependentFields() {
        return Collections.emptySet();
    }

    public Comparator<Object> getComparator() {
        return SketchHolder.COMPARATOR;
    }

    public Object compute(Map<String, Object> combinedAggregators) {
        return this.sketchValue;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public ColumnType getType(ColumnInspector signature) {
        return SketchModule.BUILD_TYPE;
    }

    public SketchConstantPostAggregator decorate(Map<String, AggregatorFactory> aggregators) {
        return this;
    }

    @JsonProperty(value="value")
    public SketchHolder getSketchValue() {
        return this.sketchValue;
    }

    public String toString() {
        return "SketchConstantPostAggregator{name='" + this.name + "', value='" + this.value + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SketchConstantPostAggregator that = (SketchConstantPostAggregator)o;
        if (!this.sketchValue.equals(that.sketchValue)) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 37 * result + this.sketchValue.hashCode();
        return result;
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(23).appendString(DigestUtils.sha1Hex((String)this.value)).build();
    }
}

