/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.joda.time.Interval;

public class SegmentDescriptor {
    private final Interval interval;
    private final String version;
    private final int partitionNumber;

    @JsonCreator
    public SegmentDescriptor(@JsonProperty(value="itvl") Interval interval, @JsonProperty(value="ver") String version, @JsonProperty(value="part") int partitionNumber) {
        this.interval = interval;
        this.version = version;
        this.partitionNumber = partitionNumber;
    }

    @JsonProperty(value="itvl")
    public Interval getInterval() {
        return this.interval;
    }

    @JsonProperty(value="ver")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="part")
    public int getPartitionNumber() {
        return this.partitionNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentDescriptor that = (SegmentDescriptor)o;
        if (this.partitionNumber != that.partitionNumber) {
            return false;
        }
        if (this.interval != null ? !this.interval.equals((Object)that.interval) : that.interval != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        int result = this.interval != null ? this.interval.hashCode() : 0;
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + this.partitionNumber;
        return result;
    }

    public String toString() {
        return "SegmentDescriptor{interval=" + this.interval + ", version='" + this.version + "', partitionNumber=" + this.partitionNumber + "}";
    }
}

