/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.emitter.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.emitter.core.Emitter;
import org.apache.druid.java.util.emitter.core.Event;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;

public class ServiceEmitter
implements Emitter {
    private final ImmutableMap<String, String> serviceDimensions;
    private final Emitter emitter;

    public ServiceEmitter(String service, String host, Emitter emitter) {
        this(service, host, emitter, (ImmutableMap<String, String>)ImmutableMap.of());
    }

    public ServiceEmitter(String service, String host, Emitter emitter, ImmutableMap<String, String> otherServiceDimensions) {
        this.serviceDimensions = ImmutableMap.builder().put((Object)"service", (Object)((String)Preconditions.checkNotNull((Object)service, (Object)"service should be non-null"))).put((Object)"host", (Object)((String)Preconditions.checkNotNull((Object)host, (Object)"host should be non-null"))).putAll(otherServiceDimensions).build();
        this.emitter = emitter;
    }

    @Override
    @LifecycleStart
    public void start() {
        this.emitter.start();
    }

    @Override
    public void emit(Event event) {
        this.emitter.emit(event);
    }

    public <E extends Event> void emit(ServiceEventBuilder<E> builder) {
        this.emit((Event)builder.build(this.serviceDimensions));
    }

    @Override
    public void flush() throws IOException {
        this.emitter.flush();
    }

    @Override
    @LifecycleStop
    public void close() throws IOException {
        this.emitter.close();
    }

    public String toString() {
        return "ServiceEmitter{serviceDimensions=" + this.serviceDimensions + ", emitter=" + this.emitter + "}";
    }
}

