/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.kernel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.druid.java.util.common.IAE;

public enum ShuffleKind {
    MIX("mix", false, false),
    HASH("hash", true, false),
    HASH_LOCAL_SORT("hashLocalSort", true, true),
    GLOBAL_SORT("globalSort", false, true);

    private final String name;
    private final boolean hash;
    private final boolean sort;

    private ShuffleKind(String name, boolean hash, boolean sort) {
        this.name = name;
        this.hash = hash;
        this.sort = sort;
    }

    @JsonCreator
    public static ShuffleKind fromString(String s) {
        for (ShuffleKind kind : ShuffleKind.values()) {
            if (!kind.toString().equals(s)) continue;
            return kind;
        }
        throw new IAE("No such shuffleKind[%s]", new Object[]{s});
    }

    public boolean isHash() {
        return this.hash;
    }

    public boolean isSort() {
        return this.sort;
    }

    @JsonValue
    public String toString() {
        return this.name;
    }
}

