/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input.table;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.msq.counters.ChannelCounters;
import org.apache.druid.msq.counters.CounterNames;
import org.apache.druid.msq.counters.CounterTracker;
import org.apache.druid.msq.exec.DataServerQueryHandler;
import org.apache.druid.msq.exec.DataServerQueryHandlerFactory;
import org.apache.druid.msq.exec.FrameContext;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.InputSliceReader;
import org.apache.druid.msq.input.ReadableInput;
import org.apache.druid.msq.input.ReadableInputs;
import org.apache.druid.msq.input.table.DataServerRequestDescriptor;
import org.apache.druid.msq.input.table.RichSegmentDescriptor;
import org.apache.druid.msq.input.table.SegmentWithDescriptor;
import org.apache.druid.msq.input.table.SegmentsInputSlice;
import org.apache.druid.msq.querykit.DataSegmentProvider;
import org.apache.druid.segment.CompleteSegment;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.Interval;

public class SegmentsInputSliceReader
implements InputSliceReader {
    private final DataSegmentProvider dataSegmentProvider;
    private final DataServerQueryHandlerFactory dataServerQueryHandlerFactory;
    private final boolean isReindex;

    public SegmentsInputSliceReader(FrameContext frameContext, boolean isReindex) {
        this.dataSegmentProvider = frameContext.dataSegmentProvider();
        this.dataServerQueryHandlerFactory = frameContext.dataServerQueryHandlerFactory();
        this.isReindex = isReindex;
    }

    @Override
    public int numReadableInputs(InputSlice slice) {
        SegmentsInputSlice segmentsInputSlice = (SegmentsInputSlice)slice;
        int servedSegmentsSize = segmentsInputSlice.getServedSegments() == null ? 0 : segmentsInputSlice.getServedSegments().size();
        return segmentsInputSlice.getDescriptors().size() + servedSegmentsSize;
    }

    @Override
    public ReadableInputs attach(int inputNumber, InputSlice slice, CounterTracker counters, Consumer<Throwable> warningPublisher) {
        SegmentsInputSlice segmentsInputSlice = (SegmentsInputSlice)slice;
        Iterator segmentIterator = Iterators.transform(this.dataSegmentIterator(segmentsInputSlice.getDataSource(), segmentsInputSlice.getDescriptors(), counters.channel(CounterNames.inputChannel(inputNumber)).setTotalFiles(slice.fileCount())), ReadableInput::segment);
        if (segmentsInputSlice.getServedSegments() == null) {
            return ReadableInputs.segments(() -> segmentIterator);
        }
        Iterator dataServerIterator = Iterators.transform(this.dataServerIterator(inputNumber, segmentsInputSlice.getDataSource(), segmentsInputSlice.getServedSegments(), counters.channel(CounterNames.inputChannel(inputNumber)).setTotalFiles(slice.fileCount())), ReadableInput::dataServerQuery);
        return ReadableInputs.segments(() -> Iterators.concat((Iterator)dataServerIterator, (Iterator)segmentIterator));
    }

    private Iterator<SegmentWithDescriptor> dataSegmentIterator(String dataSource, List<RichSegmentDescriptor> descriptors, ChannelCounters channelCounters) {
        return descriptors.stream().map(descriptor -> {
            SegmentId segmentId = SegmentId.of((String)dataSource, (Interval)descriptor.getFullInterval(), (String)descriptor.getVersion(), (int)descriptor.getPartitionNumber());
            return new SegmentWithDescriptor((Supplier<? extends ResourceHolder<CompleteSegment>>)this.dataSegmentProvider.fetchSegment(segmentId, channelCounters, this.isReindex), (RichSegmentDescriptor)((Object)descriptor));
        }).iterator();
    }

    private Iterator<DataServerQueryHandler> dataServerIterator(int inputNumber, String dataSource, List<DataServerRequestDescriptor> servedSegments, ChannelCounters channelCounters) {
        return servedSegments.stream().map(dataServerRequestDescriptor -> this.dataServerQueryHandlerFactory.createDataServerQueryHandler(inputNumber, dataSource, channelCounters, (DataServerRequestDescriptor)dataServerRequestDescriptor)).iterator();
    }
}

