/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input.table;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.msq.input.table.RichSegmentDescriptor;
import org.apache.druid.segment.CompleteSegment;

public class SegmentWithDescriptor {
    private final Supplier<? extends ResourceHolder<CompleteSegment>> segmentSupplier;
    private final RichSegmentDescriptor descriptor;

    public SegmentWithDescriptor(Supplier<? extends ResourceHolder<CompleteSegment>> segmentSupplier, RichSegmentDescriptor descriptor) {
        this.segmentSupplier = (Supplier)Preconditions.checkNotNull(segmentSupplier, (Object)"segment");
        this.descriptor = (RichSegmentDescriptor)((Object)Preconditions.checkNotNull((Object)((Object)descriptor), (Object)"descriptor"));
    }

    public ResourceHolder<CompleteSegment> getOrLoad() {
        return this.segmentSupplier.get();
    }

    public RichSegmentDescriptor getDescriptor() {
        return this.descriptor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentWithDescriptor that = (SegmentWithDescriptor)o;
        return Objects.equals(this.segmentSupplier, that.segmentSupplier) && Objects.equals((Object)this.descriptor, (Object)that.descriptor);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.segmentSupplier, this.descriptor});
    }
}

