/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.druid.msq.indexing.error.BaseMSQFault;

@JsonTypeName(value="TaskStartTimeout")
public class TaskStartTimeoutFault
extends BaseMSQFault {
    static final String CODE = "TaskStartTimeout";
    private final int pendingTasks;
    private final int totalTasks;
    private final long timeout;

    @JsonCreator
    public TaskStartTimeoutFault(@JsonProperty(value="pendingTasks") int pendingTasks, @JsonProperty(value="totalTasks") int totalTasks, @JsonProperty(value="timeout") long timeout) {
        super(CODE, "Unable to launch [%d] workers out of the total [%d] worker tasks within [%,d] seconds of the last successful worker launch. There might be insufficient available slots to start all worker tasks simultaneously. Try lowering '%s' in your query context to a number that fits within your available task capacity, or try increasing capacity.", pendingTasks, totalTasks, TimeUnit.MILLISECONDS.toSeconds(timeout), "maxNumTasks");
        this.pendingTasks = pendingTasks;
        this.totalTasks = totalTasks;
        this.timeout = timeout;
    }

    @JsonProperty
    public int getPendingTasks() {
        return this.pendingTasks;
    }

    @JsonProperty
    public int getTotalTasks() {
        return this.totalTasks;
    }

    @JsonProperty
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TaskStartTimeoutFault that = (TaskStartTimeoutFault)o;
        return this.pendingTasks == that.pendingTasks && this.totalTasks == that.totalTasks && this.timeout == that.timeout;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.pendingTasks, this.totalTasks, this.timeout);
    }
}

