/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.s3;

import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.druid.data.input.RetryingInputEntity;
import org.apache.druid.data.input.impl.CloudObjectLocation;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.storage.s3.S3Utils;
import org.apache.druid.storage.s3.ServerSideEncryptingAmazonS3;

public class S3Entity
extends RetryingInputEntity {
    private final ServerSideEncryptingAmazonS3 s3Client;
    private final CloudObjectLocation object;
    private final int maxRetries;

    S3Entity(ServerSideEncryptingAmazonS3 s3Client, CloudObjectLocation coords, int maxRetries) {
        Preconditions.checkArgument((maxRetries >= 0 ? 1 : 0) != 0);
        this.s3Client = s3Client;
        this.object = coords;
        this.maxRetries = maxRetries;
    }

    protected int getMaxRetries() {
        return this.maxRetries;
    }

    public URI getUri() {
        return this.object.toUri("s3");
    }

    protected InputStream readFrom(long offset) throws IOException {
        GetObjectRequest request = new GetObjectRequest(this.object.getBucket(), this.object.getPath());
        request.setRange(offset);
        try {
            S3Object s3Object = this.s3Client.getObject(request);
            if (s3Object == null) {
                throw new ISE("Failed to get an s3 object for bucket[%s], key[%s], and start[%d]", new Object[]{this.object.getBucket(), this.object.getPath(), offset});
            }
            return s3Object.getObjectContent();
        }
        catch (AmazonS3Exception e) {
            throw new IOException(e);
        }
    }

    protected String getPath() {
        return this.object.getPath();
    }

    public Predicate<Throwable> getRetryCondition() {
        return S3Utils.S3RETRY;
    }

    CloudObjectLocation getObject() {
        return this.object;
    }
}

