/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.parquet.simple;

import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.data.input.parquet.simple.ParquetParseSpec;
import org.apache.druid.indexer.HadoopDruidIndexerConfig;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.indexing.ReaderUtils;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;

public class DruidParquetReadSupport
extends GroupReadSupport {
    private static final Logger LOG = new Logger(DruidParquetReadSupport.class);

    private MessageType getPartialReadSchema(InitContext context) {
        ArrayList<Type> partialFields = new ArrayList<Type>();
        MessageType fullSchema = context.getFileSchema();
        String name = fullSchema.getName();
        HadoopDruidIndexerConfig config = HadoopDruidIndexerConfig.fromConfiguration((Configuration)context.getConfiguration());
        ParseSpec parseSpec = config.getParser().getParseSpec();
        JSONPathSpec flattenSpec = null;
        if (parseSpec instanceof ParquetParseSpec && ((ParquetParseSpec)parseSpec).getFlattenSpec() != null) {
            flattenSpec = (JSONPathSpec)((ParquetParseSpec)parseSpec).getFlattenSpec();
        }
        Set fullSchemaFields = fullSchema.getFields().stream().map(Type::getName).collect(Collectors.toSet());
        Set requiredFields = ReaderUtils.getColumnsRequiredForIngestion(fullSchemaFields, (TimestampSpec)parseSpec.getTimestampSpec(), (DimensionsSpec)parseSpec.getDimensionsSpec(), (TransformSpec)config.getSchema().getDataSchema().getTransformSpec(), (AggregatorFactory[])config.getSchema().getDataSchema().getAggregators(), (JSONPathSpec)flattenSpec);
        for (Type type : fullSchema.getFields()) {
            if (!requiredFields.contains(type.getName())) continue;
            partialFields.add(type);
        }
        LOG.info("Parquet schema name[%s] with full schema[%s] requires fields[%s]", new Object[]{name, fullSchemaFields, requiredFields});
        return new MessageType(name, partialFields);
    }

    public ReadSupport.ReadContext init(InitContext context) {
        MessageType requestedProjection = DruidParquetReadSupport.getSchemaForRead((MessageType)context.getFileSchema(), (MessageType)this.getPartialReadSchema(context));
        return new ReadSupport.ReadContext(requestedProjection);
    }
}

