/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.handoff;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.segment.handoff.CoordinatorBasedSegmentHandoffNotifierConfig;
import org.apache.druid.segment.handoff.SegmentHandoffNotifier;
import org.joda.time.Duration;

public class CoordinatorBasedSegmentHandoffNotifier
implements SegmentHandoffNotifier {
    private static final Logger log = new Logger(CoordinatorBasedSegmentHandoffNotifier.class);
    private final ConcurrentMap<SegmentDescriptor, Pair<Executor, Runnable>> handOffCallbacks = new ConcurrentHashMap<SegmentDescriptor, Pair<Executor, Runnable>>();
    private final CoordinatorClient coordinatorClient;
    private volatile ScheduledExecutorService scheduledExecutor;
    private final Duration pollDuration;
    private final String dataSource;
    private final String taskId;

    public CoordinatorBasedSegmentHandoffNotifier(String dataSource, CoordinatorClient coordinatorClient, CoordinatorBasedSegmentHandoffNotifierConfig config, String taskId) {
        this.dataSource = dataSource;
        this.coordinatorClient = coordinatorClient;
        this.pollDuration = config.getPollDuration();
        this.taskId = taskId;
    }

    @Override
    public boolean registerSegmentHandoffCallback(SegmentDescriptor descriptor, Executor exec, Runnable handOffRunnable) {
        log.debug("Adding SegmentHandoffCallback for dataSource[%s] Segment[%s] for task[%s]", new Object[]{this.dataSource, descriptor, this.taskId});
        Pair<Executor, Runnable> prev = this.handOffCallbacks.putIfAbsent(descriptor, (Pair<Executor, Runnable>)new Pair((Object)exec, (Object)handOffRunnable));
        return prev == null;
    }

    @Override
    public void start() {
        this.scheduledExecutor = Execs.scheduledSingleThreaded((String)"coordinator_handoff_scheduled_%d");
        this.scheduledExecutor.scheduleAtFixedRate(this::checkForSegmentHandoffs, 0L, this.pollDuration.getMillis(), TimeUnit.MILLISECONDS);
    }

    void checkForSegmentHandoffs() {
        try {
            Iterator itr = this.handOffCallbacks.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                SegmentDescriptor descriptor = (SegmentDescriptor)entry.getKey();
                try {
                    Boolean handOffComplete = (Boolean)FutureUtils.getUnchecked(this.coordinatorClient.isHandoffComplete(this.dataSource, descriptor), (boolean)true);
                    if (!Boolean.TRUE.equals(handOffComplete)) continue;
                    log.debug("Segment handoff complete for dataSource[%s] segment[%s] for task[%s]", new Object[]{this.dataSource, descriptor, this.taskId});
                    ((Executor)((Pair)entry.getValue()).lhs).execute((Runnable)((Pair)entry.getValue()).rhs);
                    itr.remove();
                }
                catch (Exception e) {
                    log.error((Throwable)e, "Exception while checking handoff for dataSource[%s] Segment[%s], taskId[%s]; will try again after [%s]", new Object[]{this.dataSource, descriptor, this.taskId, this.pollDuration});
                }
            }
            if (!this.handOffCallbacks.isEmpty()) {
                log.info("Still waiting for handoff for [%d] segments for task[%s]", new Object[]{this.handOffCallbacks.size(), this.taskId});
            }
        }
        catch (Throwable t) {
            log.error(t, "Exception while checking handoff for dataSource[%s], taskId[%s]; will try again after [%s]", new Object[]{this.dataSource, this.taskId, this.pollDuration});
        }
    }

    @Override
    public void close() {
        this.scheduledExecutor.shutdown();
    }

    Map<SegmentDescriptor, Pair<Executor, Runnable>> getHandOffCallbacks() {
        return this.handOffCallbacks;
    }
}

