/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.rpc.guice;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Binder;
import com.google.inject.Provides;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.druid.client.broker.Broker;
import org.apache.druid.client.broker.BrokerClient;
import org.apache.druid.client.broker.BrokerClientImpl;
import org.apache.druid.client.coordinator.Coordinator;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.client.coordinator.CoordinatorClientImpl;
import org.apache.druid.client.indexing.IndexingService;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.annotations.EscalatedGlobal;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutors;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.rpc.DiscoveryServiceLocator;
import org.apache.druid.rpc.ServiceClient;
import org.apache.druid.rpc.ServiceClientFactory;
import org.apache.druid.rpc.ServiceClientFactoryImpl;
import org.apache.druid.rpc.ServiceLocator;
import org.apache.druid.rpc.StandardRetryPolicy;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.rpc.indexing.OverlordClientImpl;

public class ServiceClientModule
implements DruidModule {
    private static final int CLIENT_MAX_ATTEMPTS = 6;
    private static final int CONNECT_EXEC_THREADS = 4;

    public void configure(Binder binder) {
    }

    @Provides
    @LazySingleton
    @EscalatedGlobal
    public ServiceClientFactory getServiceClientFactory(@EscalatedGlobal HttpClient httpClient) {
        return ServiceClientModule.makeServiceClientFactory(httpClient);
    }

    @Provides
    @ManageLifecycle
    @IndexingService
    public ServiceLocator makeOverlordServiceLocator(DruidNodeDiscoveryProvider discoveryProvider) {
        return new DiscoveryServiceLocator(discoveryProvider, NodeRole.OVERLORD);
    }

    @Provides
    @IndexingService
    public ServiceClient makeServiceClientForOverlord(@EscalatedGlobal ServiceClientFactory clientFactory, @IndexingService ServiceLocator serviceLocator) {
        return clientFactory.makeClient(NodeRole.OVERLORD.getJsonName(), serviceLocator, StandardRetryPolicy.builder().maxAttempts(6L).build());
    }

    @Provides
    @LazySingleton
    public OverlordClient makeOverlordClient(@Json ObjectMapper jsonMapper, @IndexingService ServiceClient serviceClient) {
        return new OverlordClientImpl(serviceClient, jsonMapper);
    }

    @Provides
    @ManageLifecycle
    @Coordinator
    public ServiceLocator makeCoordinatorServiceLocator(DruidNodeDiscoveryProvider discoveryProvider) {
        return new DiscoveryServiceLocator(discoveryProvider, NodeRole.COORDINATOR);
    }

    @Provides
    @Coordinator
    public ServiceClient makeServiceClientForCoordinator(@EscalatedGlobal ServiceClientFactory clientFactory, @Coordinator ServiceLocator serviceLocator) {
        return clientFactory.makeClient(NodeRole.COORDINATOR.getJsonName(), serviceLocator, StandardRetryPolicy.builder().maxAttempts(6L).build());
    }

    @Provides
    @LazySingleton
    public CoordinatorClient makeCoordinatorClient(@Json ObjectMapper jsonMapper, @Coordinator ServiceClient serviceClient) {
        return new CoordinatorClientImpl(serviceClient, jsonMapper);
    }

    @Provides
    @ManageLifecycle
    @Broker
    public ServiceLocator makeBrokerServiceLocator(DruidNodeDiscoveryProvider discoveryProvider) {
        return new DiscoveryServiceLocator(discoveryProvider, NodeRole.BROKER);
    }

    @Provides
    @Broker
    public ServiceClient makeServiceClientForBroker(@EscalatedGlobal ServiceClientFactory clientFactory, @Broker ServiceLocator serviceLocator) {
        return clientFactory.makeClient(NodeRole.BROKER.getJsonName(), serviceLocator, StandardRetryPolicy.builder().maxAttempts(6L).build());
    }

    @Provides
    @LazySingleton
    public BrokerClient makeBrokerClient(@Json ObjectMapper jsonMapper, @Broker ServiceClient serviceClient) {
        return new BrokerClientImpl(serviceClient, jsonMapper);
    }

    public static ServiceClientFactory makeServiceClientFactory(@EscalatedGlobal HttpClient httpClient) {
        ScheduledExecutorService connectExec = ScheduledExecutors.fixed((int)4, (String)"ServiceClientFactory-%d");
        return new ServiceClientFactoryImpl(httpClient, connectExec);
    }
}

