/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.HumanReadableBytesRange;
import org.apache.druid.segment.loading.SegmentLoaderConfig;

public class DruidServerConfig {
    @JsonProperty
    @HumanReadableBytesRange(min=0L)
    private HumanReadableBytes maxSize = HumanReadableBytes.ZERO;
    @JsonProperty
    private String tier = "_default_tier";
    @JsonProperty
    private int priority = 0;
    @JsonProperty
    @NotNull
    private Set<String> hiddenProperties = Sets.newHashSet((Object[])new String[]{"druid.s3.accessKey", "druid.s3.secretKey", "druid.metadata.storage.connector.password", "password", "key", "token", "pwd"});
    private SegmentLoaderConfig segmentLoaderConfig;

    @Inject
    @JsonCreator
    public DruidServerConfig(@JacksonInject SegmentLoaderConfig segmentLoaderConfig) {
        this.segmentLoaderConfig = segmentLoaderConfig;
    }

    public long getMaxSize() {
        if (this.maxSize.equals((Object)HumanReadableBytes.ZERO)) {
            return this.segmentLoaderConfig.getCombinedMaxSize();
        }
        return this.maxSize.getBytes();
    }

    public String getTier() {
        return this.tier;
    }

    public int getPriority() {
        return this.priority;
    }

    public Set<String> getHiddenProperties() {
        return this.hiddenProperties;
    }
}

