/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.druid.client.DruidDataSource;
import org.apache.druid.client.DruidServerConfig;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;

public class DruidServer
implements Comparable<DruidServer> {
    public static final int DEFAULT_PRIORITY = 0;
    public static final int DEFAULT_NUM_REPLICANTS = 2;
    public static final String DEFAULT_TIER = "_default_tier";
    private static final Logger log = new Logger(DruidServer.class);
    private final DruidServerMetadata metadata;
    private final ConcurrentHashMap<String, DruidDataSource> dataSources = new ConcurrentHashMap();
    private final AtomicInteger totalSegments = new AtomicInteger();
    private final AtomicLong currSize = new AtomicLong(0L);

    public DruidServer(DruidNode node, DruidServerConfig config, ServerType type) {
        this(node.getHostAndPortToUse(), node.getHostAndPort(), node.getHostAndTlsPort(), config.getMaxSize(), type, config.getTier(), 0);
    }

    @JsonCreator
    public DruidServer(@JsonProperty(value="name") String name, @JsonProperty(value="host") String hostAndPort, @JsonProperty(value="hostAndTlsPort") String hostAndTlsPort, @JsonProperty(value="maxSize") long maxSize, @JsonProperty(value="type") ServerType type, @JsonProperty(value="tier") String tier, @JsonProperty(value="priority") int priority) {
        this(new DruidServerMetadata(name, hostAndPort, hostAndTlsPort, maxSize, type, tier, priority));
    }

    public DruidServer(DruidServerMetadata metadata) {
        this.metadata = metadata;
    }

    @JsonProperty
    public String getName() {
        return this.metadata.getName();
    }

    public DruidServerMetadata getMetadata() {
        return this.metadata;
    }

    public String getHost() {
        return this.getHostAndTlsPort() != null ? this.getHostAndTlsPort() : this.getHostAndPort();
    }

    @JsonProperty(value="host")
    public String getHostAndPort() {
        return this.metadata.getHostAndPort();
    }

    @JsonProperty
    public String getHostAndTlsPort() {
        return this.metadata.getHostAndTlsPort();
    }

    public long getCurrSize() {
        return this.currSize.get();
    }

    @JsonProperty
    public long getMaxSize() {
        return this.metadata.getMaxSize();
    }

    @JsonProperty
    public ServerType getType() {
        return this.metadata.getType();
    }

    @JsonProperty
    public String getTier() {
        return this.metadata.getTier();
    }

    public boolean isSegmentReplicationTarget() {
        return this.metadata.isSegmentReplicationTarget();
    }

    public boolean isSegmentBroadcastTarget() {
        return this.metadata.isSegmentBroadcastTarget();
    }

    public boolean isSegmentReplicationOrBroadcastTarget() {
        return this.metadata.isSegmentReplicationTarget() || this.metadata.isSegmentBroadcastTarget();
    }

    @JsonProperty
    public int getPriority() {
        return this.metadata.getPriority();
    }

    public String getScheme() {
        return this.metadata.getHostAndTlsPort() != null ? "https" : "http";
    }

    public Iterable<DataSegment> iterateAllSegments() {
        return () -> this.dataSources.values().stream().flatMap(dataSource -> dataSource.getSegments().stream()).iterator();
    }

    public int getTotalSegments() {
        return this.totalSegments.get();
    }

    public DataSegment getSegment(SegmentId segmentId) {
        DruidDataSource dataSource = this.dataSources.get(segmentId.getDataSource());
        if (dataSource == null) {
            return null;
        }
        return dataSource.getSegment(segmentId);
    }

    public DruidServer addDataSegment(DataSegment segment) {
        this.dataSources.compute(segment.getDataSource(), (dataSourceName, dataSource) -> {
            if (dataSource == null) {
                dataSource = new DruidDataSource((String)dataSourceName, (Map<String, String>)ImmutableMap.of((Object)"client", (Object)"side"));
            }
            if (dataSource.addSegmentIfAbsent(segment)) {
                this.currSize.addAndGet(segment.getSize());
                this.totalSegments.incrementAndGet();
            } else {
                log.warn("Asked to add data segment that already exists!? server[%s], segment[%s]", new Object[]{this.getName(), segment.getId()});
            }
            return dataSource;
        });
        return this;
    }

    public DruidServer addDataSegments(DruidServer server) {
        server.iterateAllSegments().forEach(this::addDataSegment);
        return this;
    }

    @Nullable
    public DataSegment removeDataSegment(SegmentId segmentId) {
        DataSegment[] segmentRemoved = new DataSegment[1];
        this.dataSources.compute(segmentId.getDataSource(), (dataSourceName, dataSource) -> {
            if (dataSource == null) {
                log.warn("Asked to remove data segment from a data source that doesn't exist!? server[%s], segment[%s]", new Object[]{this.getName(), segmentId});
                return null;
            }
            DataSegment segment = dataSource.removeSegment(segmentId);
            if (segment != null) {
                segmentRemoved[0] = segment;
                this.currSize.addAndGet(-segment.getSize());
                this.totalSegments.decrementAndGet();
            } else {
                log.warn("Asked to remove data segment that doesn't exist!? server[%s], segment[%s]", new Object[]{this.getName(), segmentId});
            }
            return dataSource.isEmpty() ? null : dataSource;
        });
        return segmentRemoved[0];
    }

    public DruidDataSource getDataSource(String dataSource) {
        return this.dataSources.get(dataSource);
    }

    public Collection<DruidDataSource> getDataSources() {
        return this.dataSources.values();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DruidServer)) {
            return false;
        }
        DruidServer that = (DruidServer)o;
        return this.metadata.equals(that.metadata);
    }

    public int hashCode() {
        return this.metadata.hashCode();
    }

    public String toString() {
        return this.metadata.toString();
    }

    @Override
    public int compareTo(DruidServer o) {
        return this.getName().compareTo(o.getName());
    }

    public ImmutableDruidServer toImmutableDruidServer() {
        ImmutableMap immutableDataSources = ImmutableMap.copyOf((Map)Maps.transformValues(this.dataSources, DruidDataSource::toImmutableDruidDataSource));
        long size = immutableDataSources.values().stream().mapToLong(ImmutableDruidDataSource::getTotalSizeOfSegments).sum();
        int totalSegments = immutableDataSources.values().stream().mapToInt(dataSource -> dataSource.getSegments().size()).sum();
        return new ImmutableDruidServer(this.metadata, size, (ImmutableMap<String, ImmutableDruidDataSource>)immutableDataSources, totalSegments);
    }

    public DruidServer copyWithoutSegments() {
        return new DruidServer(this.getName(), this.getHostAndPort(), this.getHostAndTlsPort(), this.getMaxSize(), this.getType(), this.getTier(), this.getPriority());
    }
}

