/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1CronJobSpec;
import io.kubernetes.client.openapi.models.V1CronJobSpecFluent;
import io.kubernetes.client.openapi.models.V1JobTemplateSpec;
import io.kubernetes.client.openapi.models.V1JobTemplateSpecBuilder;
import io.kubernetes.client.openapi.models.V1JobTemplateSpecFluentImpl;
import java.util.Objects;

public class V1CronJobSpecFluentImpl<A extends V1CronJobSpecFluent<A>>
extends BaseFluent<A>
implements V1CronJobSpecFluent<A> {
    private String concurrencyPolicy;
    private Integer failedJobsHistoryLimit;
    private V1JobTemplateSpecBuilder jobTemplate;
    private String schedule;
    private Long startingDeadlineSeconds;
    private Integer successfulJobsHistoryLimit;
    private Boolean suspend;
    private String timeZone;

    public V1CronJobSpecFluentImpl() {
    }

    public V1CronJobSpecFluentImpl(V1CronJobSpec instance) {
        if (instance != null) {
            this.withConcurrencyPolicy(instance.getConcurrencyPolicy());
            this.withFailedJobsHistoryLimit(instance.getFailedJobsHistoryLimit());
            this.withJobTemplate(instance.getJobTemplate());
            this.withSchedule(instance.getSchedule());
            this.withStartingDeadlineSeconds(instance.getStartingDeadlineSeconds());
            this.withSuccessfulJobsHistoryLimit(instance.getSuccessfulJobsHistoryLimit());
            this.withSuspend(instance.getSuspend());
            this.withTimeZone(instance.getTimeZone());
        }
    }

    @Override
    public String getConcurrencyPolicy() {
        return this.concurrencyPolicy;
    }

    @Override
    public A withConcurrencyPolicy(String concurrencyPolicy) {
        this.concurrencyPolicy = concurrencyPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasConcurrencyPolicy() {
        return this.concurrencyPolicy != null;
    }

    @Override
    public Integer getFailedJobsHistoryLimit() {
        return this.failedJobsHistoryLimit;
    }

    @Override
    public A withFailedJobsHistoryLimit(Integer failedJobsHistoryLimit) {
        this.failedJobsHistoryLimit = failedJobsHistoryLimit;
        return (A)this;
    }

    @Override
    public Boolean hasFailedJobsHistoryLimit() {
        return this.failedJobsHistoryLimit != null;
    }

    @Override
    @Deprecated
    public V1JobTemplateSpec getJobTemplate() {
        return this.jobTemplate != null ? this.jobTemplate.build() : null;
    }

    @Override
    public V1JobTemplateSpec buildJobTemplate() {
        return this.jobTemplate != null ? this.jobTemplate.build() : null;
    }

    @Override
    public A withJobTemplate(V1JobTemplateSpec jobTemplate) {
        this._visitables.get("jobTemplate").remove(this.jobTemplate);
        if (jobTemplate != null) {
            this.jobTemplate = new V1JobTemplateSpecBuilder(jobTemplate);
            this._visitables.get("jobTemplate").add(this.jobTemplate);
        } else {
            this.jobTemplate = null;
            this._visitables.get("jobTemplate").remove(this.jobTemplate);
        }
        return (A)this;
    }

    @Override
    public Boolean hasJobTemplate() {
        return this.jobTemplate != null;
    }

    @Override
    public V1CronJobSpecFluent.JobTemplateNested<A> withNewJobTemplate() {
        return new JobTemplateNestedImpl();
    }

    @Override
    public V1CronJobSpecFluent.JobTemplateNested<A> withNewJobTemplateLike(V1JobTemplateSpec item) {
        return new JobTemplateNestedImpl(item);
    }

    @Override
    public V1CronJobSpecFluent.JobTemplateNested<A> editJobTemplate() {
        return this.withNewJobTemplateLike(this.getJobTemplate());
    }

    @Override
    public V1CronJobSpecFluent.JobTemplateNested<A> editOrNewJobTemplate() {
        return this.withNewJobTemplateLike(this.getJobTemplate() != null ? this.getJobTemplate() : new V1JobTemplateSpecBuilder().build());
    }

    @Override
    public V1CronJobSpecFluent.JobTemplateNested<A> editOrNewJobTemplateLike(V1JobTemplateSpec item) {
        return this.withNewJobTemplateLike(this.getJobTemplate() != null ? this.getJobTemplate() : item);
    }

    @Override
    public String getSchedule() {
        return this.schedule;
    }

    @Override
    public A withSchedule(String schedule) {
        this.schedule = schedule;
        return (A)this;
    }

    @Override
    public Boolean hasSchedule() {
        return this.schedule != null;
    }

    @Override
    public Long getStartingDeadlineSeconds() {
        return this.startingDeadlineSeconds;
    }

    @Override
    public A withStartingDeadlineSeconds(Long startingDeadlineSeconds) {
        this.startingDeadlineSeconds = startingDeadlineSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasStartingDeadlineSeconds() {
        return this.startingDeadlineSeconds != null;
    }

    @Override
    public Integer getSuccessfulJobsHistoryLimit() {
        return this.successfulJobsHistoryLimit;
    }

    @Override
    public A withSuccessfulJobsHistoryLimit(Integer successfulJobsHistoryLimit) {
        this.successfulJobsHistoryLimit = successfulJobsHistoryLimit;
        return (A)this;
    }

    @Override
    public Boolean hasSuccessfulJobsHistoryLimit() {
        return this.successfulJobsHistoryLimit != null;
    }

    @Override
    public Boolean getSuspend() {
        return this.suspend;
    }

    @Override
    public A withSuspend(Boolean suspend) {
        this.suspend = suspend;
        return (A)this;
    }

    @Override
    public Boolean hasSuspend() {
        return this.suspend != null;
    }

    @Override
    public String getTimeZone() {
        return this.timeZone;
    }

    @Override
    public A withTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return (A)this;
    }

    @Override
    public Boolean hasTimeZone() {
        return this.timeZone != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1CronJobSpecFluentImpl that = (V1CronJobSpecFluentImpl)o;
        if (!Objects.equals(this.concurrencyPolicy, that.concurrencyPolicy)) {
            return false;
        }
        if (!Objects.equals(this.failedJobsHistoryLimit, that.failedJobsHistoryLimit)) {
            return false;
        }
        if (!Objects.equals(this.jobTemplate, that.jobTemplate)) {
            return false;
        }
        if (!Objects.equals(this.schedule, that.schedule)) {
            return false;
        }
        if (!Objects.equals(this.startingDeadlineSeconds, that.startingDeadlineSeconds)) {
            return false;
        }
        if (!Objects.equals(this.successfulJobsHistoryLimit, that.successfulJobsHistoryLimit)) {
            return false;
        }
        if (!Objects.equals(this.suspend, that.suspend)) {
            return false;
        }
        return Objects.equals(this.timeZone, that.timeZone);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.concurrencyPolicy, this.failedJobsHistoryLimit, this.jobTemplate, this.schedule, this.startingDeadlineSeconds, this.successfulJobsHistoryLimit, this.suspend, this.timeZone, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.concurrencyPolicy != null) {
            sb.append("concurrencyPolicy:");
            sb.append(this.concurrencyPolicy + ",");
        }
        if (this.failedJobsHistoryLimit != null) {
            sb.append("failedJobsHistoryLimit:");
            sb.append(this.failedJobsHistoryLimit + ",");
        }
        if (this.jobTemplate != null) {
            sb.append("jobTemplate:");
            sb.append(this.jobTemplate + ",");
        }
        if (this.schedule != null) {
            sb.append("schedule:");
            sb.append(this.schedule + ",");
        }
        if (this.startingDeadlineSeconds != null) {
            sb.append("startingDeadlineSeconds:");
            sb.append(this.startingDeadlineSeconds + ",");
        }
        if (this.successfulJobsHistoryLimit != null) {
            sb.append("successfulJobsHistoryLimit:");
            sb.append(this.successfulJobsHistoryLimit + ",");
        }
        if (this.suspend != null) {
            sb.append("suspend:");
            sb.append(this.suspend + ",");
        }
        if (this.timeZone != null) {
            sb.append("timeZone:");
            sb.append(this.timeZone);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withSuspend() {
        return this.withSuspend(true);
    }

    class JobTemplateNestedImpl<N>
    extends V1JobTemplateSpecFluentImpl<V1CronJobSpecFluent.JobTemplateNested<N>>
    implements V1CronJobSpecFluent.JobTemplateNested<N>,
    Nested<N> {
        V1JobTemplateSpecBuilder builder;

        JobTemplateNestedImpl(V1JobTemplateSpec item) {
            this.builder = new V1JobTemplateSpecBuilder(this, item);
        }

        JobTemplateNestedImpl() {
            this.builder = new V1JobTemplateSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1CronJobSpecFluentImpl.this.withJobTemplate(this.builder.build());
        }

        @Override
        public N endJobTemplate() {
            return this.and();
        }
    }
}

