/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPipelineSyncPolicy;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import java.net.MalformedURLException;
import reactor.core.publisher.Mono;

public class HostPolicy
implements HttpPipelinePolicy {
    private static final ClientLogger LOGGER = new ClientLogger(HostPolicy.class);
    private final String host;
    private final HttpPipelineSyncPolicy inner = new HttpPipelineSyncPolicy(){

        @Override
        protected void beforeSendingRequest(HttpPipelineCallContext context) {
            LOGGER.log(LogLevel.VERBOSE, () -> "Setting host to " + HostPolicy.this.host);
            UrlBuilder urlBuilder = UrlBuilder.parse(context.getHttpRequest().getUrl());
            try {
                context.getHttpRequest().setUrl(urlBuilder.setHost(HostPolicy.this.host).toUrl());
            }
            catch (MalformedURLException e) {
                throw LOGGER.logExceptionAsError(new RuntimeException(String.format("Host URL '%s' is invalid.", HostPolicy.this.host), e));
            }
        }
    };

    public HostPolicy(String host) {
        this.host = host;
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        return this.inner.process(context, next);
    }

    @Override
    public HttpResponse processSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next) {
        return this.inner.processSync(context, next);
    }
}

