/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.models.Action;
import com.azure.resourcemanager.monitor.models.AlertSeverity;
import com.azure.resourcemanager.monitor.models.AzNsActionGroup;
import com.azure.resourcemanager.monitor.models.TriggerCondition;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="odata.type")
@JsonTypeName(value="Microsoft.WindowsAzure.Management.Monitoring.Alerts.Models.Microsoft.AppInsights.Nexus.DataContracts.Resources.ScheduledQueryRules.AlertingAction")
public final class AlertingAction
extends Action {
    @JsonProperty(value="severity", required=true)
    private AlertSeverity severity;
    @JsonProperty(value="aznsAction")
    private AzNsActionGroup aznsAction;
    @JsonProperty(value="throttlingInMin")
    private Integer throttlingInMin;
    @JsonProperty(value="trigger", required=true)
    private TriggerCondition trigger;
    private static final ClientLogger LOGGER = new ClientLogger(AlertingAction.class);

    public AlertSeverity severity() {
        return this.severity;
    }

    public AlertingAction withSeverity(AlertSeverity severity) {
        this.severity = severity;
        return this;
    }

    public AzNsActionGroup aznsAction() {
        return this.aznsAction;
    }

    public AlertingAction withAznsAction(AzNsActionGroup aznsAction) {
        this.aznsAction = aznsAction;
        return this;
    }

    public Integer throttlingInMin() {
        return this.throttlingInMin;
    }

    public AlertingAction withThrottlingInMin(Integer throttlingInMin) {
        this.throttlingInMin = throttlingInMin;
        return this;
    }

    public TriggerCondition trigger() {
        return this.trigger;
    }

    public AlertingAction withTrigger(TriggerCondition trigger) {
        this.trigger = trigger;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.severity() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property severity in model AlertingAction"));
        }
        if (this.aznsAction() != null) {
            this.aznsAction().validate();
        }
        if (this.trigger() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property trigger in model AlertingAction"));
        }
        this.trigger().validate();
    }
}

