/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.SsisLogLocationTypeProperties;
import com.azure.resourcemanager.datafactory.models.SsisAccessCredential;
import com.azure.resourcemanager.datafactory.models.SsisLogLocationType;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class SsisLogLocation {
    @JsonProperty(value="logPath", required=true)
    private Object logPath;
    @JsonProperty(value="type", required=true)
    private SsisLogLocationType type;
    @JsonProperty(value="typeProperties", required=true)
    private SsisLogLocationTypeProperties innerTypeProperties = new SsisLogLocationTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(SsisLogLocation.class);

    public Object logPath() {
        return this.logPath;
    }

    public SsisLogLocation withLogPath(Object logPath) {
        this.logPath = logPath;
        return this;
    }

    public SsisLogLocationType type() {
        return this.type;
    }

    public SsisLogLocation withType(SsisLogLocationType type) {
        this.type = type;
        return this;
    }

    private SsisLogLocationTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    public SsisAccessCredential accessCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().accessCredential();
    }

    public SsisLogLocation withAccessCredential(SsisAccessCredential accessCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SsisLogLocationTypeProperties();
        }
        this.innerTypeProperties().withAccessCredential(accessCredential);
        return this;
    }

    public Object logRefreshInterval() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().logRefreshInterval();
    }

    public SsisLogLocation withLogRefreshInterval(Object logRefreshInterval) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SsisLogLocationTypeProperties();
        }
        this.innerTypeProperties().withLogRefreshInterval(logRefreshInterval);
        return this;
    }

    public void validate() {
        if (this.logPath() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property logPath in model SsisLogLocation"));
        }
        if (this.type() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property type in model SsisLogLocation"));
        }
        if (this.innerTypeProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model SsisLogLocation"));
        }
        this.innerTypeProperties().validate();
    }
}

