/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.Office365DatasetTypeProperties;
import com.azure.resourcemanager.datafactory.models.Dataset;
import com.azure.resourcemanager.datafactory.models.DatasetFolder;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="Office365Table")
public final class Office365Dataset
extends Dataset {
    @JsonProperty(value="typeProperties", required=true)
    private Office365DatasetTypeProperties innerTypeProperties = new Office365DatasetTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(Office365Dataset.class);

    private Office365DatasetTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public Office365Dataset withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public Office365Dataset withStructure(Object structure) {
        super.withStructure(structure);
        return this;
    }

    @Override
    public Office365Dataset withSchema(Object schema) {
        super.withSchema(schema);
        return this;
    }

    @Override
    public Office365Dataset withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public Office365Dataset withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public Office365Dataset withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    @Override
    public Office365Dataset withFolder(DatasetFolder folder) {
        super.withFolder(folder);
        return this;
    }

    public Object tableName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().tableName();
    }

    public Office365Dataset withTableName(Object tableName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new Office365DatasetTypeProperties();
        }
        this.innerTypeProperties().withTableName(tableName);
        return this;
    }

    public Object predicate() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().predicate();
    }

    public Office365Dataset withPredicate(Object predicate) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new Office365DatasetTypeProperties();
        }
        this.innerTypeProperties().withPredicate(predicate);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerTypeProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model Office365Dataset"));
        }
        this.innerTypeProperties().validate();
    }
}

