/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.rpc;

import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.dolphinscheduler.extract.master.ILogicTaskExecutorOperator;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.server.master.engine.executor.LogicTaskEngineDelegator;
import org.apache.dolphinscheduler.task.executor.eventbus.ITaskExecutorLifecycleEventReporter;
import org.apache.dolphinscheduler.task.executor.log.TaskExecutorMDCUtils;
import org.apache.dolphinscheduler.task.executor.operations.TaskExecutorDispatchRequest;
import org.apache.dolphinscheduler.task.executor.operations.TaskExecutorDispatchResponse;
import org.apache.dolphinscheduler.task.executor.operations.TaskExecutorKillRequest;
import org.apache.dolphinscheduler.task.executor.operations.TaskExecutorKillResponse;
import org.apache.dolphinscheduler.task.executor.operations.TaskExecutorPauseRequest;
import org.apache.dolphinscheduler.task.executor.operations.TaskExecutorPauseResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogicTaskExecutorOperatorImpl
implements ILogicTaskExecutorOperator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogicTaskExecutorOperatorImpl.class);
    @Autowired
    private LogicTaskEngineDelegator logicTaskEngineDelegator;

    /*
     * Loose catch block
     */
    public TaskExecutorDispatchResponse dispatchTask(TaskExecutorDispatchRequest taskExecutorDispatchRequest) {
        TaskExecutionContext taskExecutionContext = taskExecutorDispatchRequest.getTaskExecutionContext();
        Throwable throwable = null;
        try (TaskExecutorMDCUtils.MDCAutoClosable ignore = TaskExecutorMDCUtils.logWithMDC((int)taskExecutionContext.getTaskInstanceId());){
            log.info("Receive  {}", (Object)taskExecutorDispatchRequest);
            try {
                this.logicTaskEngineDelegator.dispatchLogicTask(taskExecutionContext);
                log.info("Handle {} success", (Object)taskExecutorDispatchRequest);
                TaskExecutorDispatchResponse taskExecutorDispatchResponse = TaskExecutorDispatchResponse.success();
                return taskExecutorDispatchResponse;
            }
            catch (Throwable throwable2) {
                TaskExecutorDispatchResponse taskExecutorDispatchResponse;
                block17: {
                    block18: {
                        log.error("Handle {} failed", (Object)taskExecutorDispatchRequest, (Object)throwable2);
                        taskExecutorDispatchResponse = TaskExecutorDispatchResponse.failed((String)ExceptionUtils.getMessage((Throwable)throwable2));
                        if (ignore == null) break block17;
                        if (throwable == null) break block18;
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        break block17;
                    }
                    ignore.close();
                }
                return taskExecutorDispatchResponse;
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    throw throwable5;
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    public TaskExecutorPauseResponse pauseTask(TaskExecutorPauseRequest taskPauseRequest) {
        int taskInstanceId = taskPauseRequest.getTaskInstanceId();
        Throwable throwable = null;
        try (TaskExecutorMDCUtils.MDCAutoClosable ignore = TaskExecutorMDCUtils.logWithMDC((int)taskInstanceId);){
            log.info("Receive {}", (Object)taskPauseRequest);
            try {
                this.logicTaskEngineDelegator.pauseLogicTask(taskInstanceId);
                log.info("Handle {} success", (Object)taskPauseRequest);
                TaskExecutorPauseResponse taskExecutorPauseResponse = TaskExecutorPauseResponse.success();
                return taskExecutorPauseResponse;
            }
            catch (Throwable throwable2) {
                TaskExecutorPauseResponse taskExecutorPauseResponse;
                block17: {
                    block18: {
                        log.error("Handle {} failed", (Object)taskPauseRequest, (Object)throwable2);
                        taskExecutorPauseResponse = TaskExecutorPauseResponse.fail((String)ExceptionUtils.getMessage((Throwable)throwable2));
                        if (ignore == null) break block17;
                        if (throwable == null) break block18;
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        break block17;
                    }
                    ignore.close();
                }
                return taskExecutorPauseResponse;
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    throw throwable5;
                }
            }
        }
    }

    public void ackTaskExecutorLifecycleEvent(ITaskExecutorLifecycleEventReporter.TaskExecutorLifecycleEventAck taskExecutorLifecycleEventAck) {
        int taskExecutorId = taskExecutorLifecycleEventAck.getTaskExecutorId();
        try (TaskExecutorMDCUtils.MDCAutoClosable ignore = TaskExecutorMDCUtils.logWithMDC((int)taskExecutorId);){
            log.info("Receive : {}", (Object)taskExecutorLifecycleEventAck);
            this.logicTaskEngineDelegator.ackLogicTaskExecutionEvent(taskExecutorLifecycleEventAck);
        }
    }

    /*
     * Loose catch block
     */
    public TaskExecutorKillResponse killTask(TaskExecutorKillRequest taskKillRequest) {
        int taskInstanceId = taskKillRequest.getTaskInstanceId();
        Throwable throwable = null;
        try (TaskExecutorMDCUtils.MDCAutoClosable ignore = TaskExecutorMDCUtils.logWithMDC((int)taskInstanceId);){
            log.info("Receive  {}", (Object)taskKillRequest);
            try {
                this.logicTaskEngineDelegator.killLogicTask(taskInstanceId);
                log.info("Handle  {} success", (Object)taskKillRequest);
                TaskExecutorKillResponse taskExecutorKillResponse = TaskExecutorKillResponse.success();
                return taskExecutorKillResponse;
            }
            catch (Throwable throwable2) {
                TaskExecutorKillResponse taskExecutorKillResponse;
                block17: {
                    block18: {
                        log.error("Handle  {} failed", (Object)taskKillRequest, (Object)throwable2);
                        taskExecutorKillResponse = TaskExecutorKillResponse.fail((String)ExceptionUtils.getMessage((Throwable)throwable2));
                        if (ignore == null) break block17;
                        if (throwable == null) break block18;
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        break block17;
                    }
                    ignore.close();
                }
                return taskExecutorKillResponse;
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    throw throwable5;
                }
            }
        }
    }
}

