/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.common.enums.TaskDependType;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.server.master.engine.graph.IWorkflowGraph;

public class WorkflowGraphTopologyLogicalVisitor {
    private final IWorkflowGraph workflowGraph;
    private final TaskDependType taskDependType;
    private final Set<String> startNodes;
    private final BiConsumer<String, Set<String>> visitFunction;

    private WorkflowGraphTopologyLogicalVisitor(WorkflowGraphBfsVisitorBuilder workflowGraphBfsVisitorBuilder) {
        this.taskDependType = workflowGraphBfsVisitorBuilder.taskDependType;
        this.workflowGraph = (IWorkflowGraph)Preconditions.checkNotNull((Object)workflowGraphBfsVisitorBuilder.workflowGraph);
        this.visitFunction = (BiConsumer)Preconditions.checkNotNull((Object)workflowGraphBfsVisitorBuilder.visitFunction);
        this.startNodes = CollectionUtils.isEmpty((Collection)workflowGraphBfsVisitorBuilder.startNodes) ? new HashSet<String>(this.workflowGraph.getStartNodes()) : new HashSet<String>((Collection)Preconditions.checkNotNull((Object)workflowGraphBfsVisitorBuilder.startNodes));
    }

    public static WorkflowGraphBfsVisitorBuilder builder() {
        return new WorkflowGraphBfsVisitorBuilder();
    }

    public void visit() {
        switch (this.taskDependType) {
            case TASK_ONLY: {
                this.visitStartNodesOnly();
                break;
            }
            case TASK_PRE: {
                this.visitToStartNodes();
                break;
            }
            case TASK_POST: {
                this.visitFromStartNodes();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported task depend type: " + this.taskDependType);
            }
        }
    }

    private void visitStartNodesOnly() {
        this.doVisitationInSubGraph(Sets.newHashSet(this.startNodes));
    }

    private void visitToStartNodes() {
        LinkedList<String> bootstrapTaskCodes = new LinkedList<String>(this.startNodes);
        HashSet<String> subGraphNodes = new HashSet<String>();
        while (!bootstrapTaskCodes.isEmpty()) {
            String taskName = bootstrapTaskCodes.removeFirst();
            if (subGraphNodes.contains(taskName)) continue;
            subGraphNodes.add(taskName);
            Set<String> successors = this.workflowGraph.getPredecessors(taskName);
            bootstrapTaskCodes.addAll(successors);
        }
        this.doVisitationInSubGraph(subGraphNodes);
    }

    private void visitFromStartNodes() {
        LinkedList<String> bootstrapTaskCodes = new LinkedList<String>(this.startNodes);
        HashSet<String> subGraphNodes = new HashSet<String>();
        while (!bootstrapTaskCodes.isEmpty()) {
            String taskName = bootstrapTaskCodes.removeFirst();
            if (subGraphNodes.contains(taskName)) continue;
            subGraphNodes.add(taskName);
            Set<String> successors = this.workflowGraph.getSuccessors(taskName);
            bootstrapTaskCodes.addAll(successors);
        }
        this.doVisitationInSubGraph(subGraphNodes);
    }

    private void doVisitationInSubGraph(Set<String> subGraphNodes) {
        Map<String, Integer> inDegreeMap = this.workflowGraph.getAllTaskNodes().stream().collect(Collectors.toMap(TaskDefinition::getName, taskDefinition -> this.workflowGraph.getPredecessors(taskDefinition.getName()).size()));
        LinkedList bootstrapTaskCodes = inDegreeMap.entrySet().stream().filter(entry -> (Integer)entry.getValue() == 0).map(Map.Entry::getKey).collect(Collectors.toCollection(LinkedList::new));
        HashSet<String> visitedTaskCodes = new HashSet<String>();
        while (!bootstrapTaskCodes.isEmpty()) {
            String taskName = (String)bootstrapTaskCodes.removeFirst();
            if (inDegreeMap.get(taskName) > 0 || visitedTaskCodes.contains(taskName)) continue;
            visitedTaskCodes.add(taskName);
            Set<String> successors = this.workflowGraph.getSuccessors(taskName);
            if (subGraphNodes.contains(taskName)) {
                this.visitFunction.accept(taskName, successors);
            }
            for (String successor : successors) {
                inDegreeMap.put(successor, inDegreeMap.get(successor) - 1);
            }
            bootstrapTaskCodes.addAll(successors);
        }
    }

    public static class WorkflowGraphBfsVisitorBuilder {
        private IWorkflowGraph workflowGraph;
        private List<String> startNodes;
        private TaskDependType taskDependType = TaskDependType.TASK_POST;
        private BiConsumer<String, Set<String>> visitFunction;

        public WorkflowGraphBfsVisitorBuilder onWorkflowGraph(IWorkflowGraph workflowGraph) {
            this.workflowGraph = workflowGraph;
            return this;
        }

        public WorkflowGraphBfsVisitorBuilder taskDependType(TaskDependType taskDependType) {
            this.taskDependType = taskDependType;
            return this;
        }

        public WorkflowGraphBfsVisitorBuilder fromTask(List<String> startNodes) {
            this.startNodes = startNodes;
            return this;
        }

        public WorkflowGraphBfsVisitorBuilder doVisitFunction(BiConsumer<String, Set<String>> visitFunction) {
            this.visitFunction = visitFunction;
            return this;
        }

        public WorkflowGraphTopologyLogicalVisitor build() {
            return new WorkflowGraphTopologyLogicalVisitor(this);
        }
    }
}

