/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.task.executor;

import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.log.TaskInstanceLogHeader;
import org.apache.dolphinscheduler.plugin.task.api.log.TaskLogMarkers;
import org.apache.dolphinscheduler.task.executor.ITaskExecutor;
import org.apache.dolphinscheduler.task.executor.TaskExecutorState;
import org.apache.dolphinscheduler.task.executor.eventbus.TaskExecutorEventBus;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorStartedLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.exceptions.TaskExecutorRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTaskExecutor
implements ITaskExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractTaskExecutor.class);
    private static final long DEFAULT_TRACK_INTERVAL = 10000L;
    private long latestStateTrackTime;
    private boolean startFlag;
    protected final AtomicReference<TaskExecutorState> taskExecutorState = new AtomicReference();
    protected final TaskExecutionContext taskExecutionContext;
    protected final TaskExecutorEventBus taskExecutorEventBus;

    public AbstractTaskExecutor(TaskExecutionContext taskExecutionContext, TaskExecutorEventBus taskExecutorEventBus) {
        this.taskExecutionContext = taskExecutionContext;
        this.taskExecutorEventBus = taskExecutorEventBus;
        this.latestStateTrackTime = 0L;
        this.startFlag = false;
        this.transitTaskExecutorState(TaskExecutorState.INITIALIZED);
    }

    @Override
    public void start() {
        if (this.startFlag) {
            throw new TaskExecutorRuntimeException(this + " has already started");
        }
        this.startFlag = true;
        TaskInstanceLogHeader.printInitializeTaskContextHeader();
        this.initializeTaskContext();
        this.publishTaskRunningEvent();
        TaskInstanceLogHeader.printLoadTaskInstancePluginHeader();
        this.initializeTaskPlugin();
        TaskInstanceLogHeader.printExecuteTaskHeader();
        if (this.taskExecutionContext.getDryRun() == Flag.YES.getCode()) {
            log.info("The task: {} is dryRun model, skip the trigger stage.", (Object)this.taskExecutionContext.getTaskName());
            this.transitTaskExecutorState(TaskExecutorState.SUCCEEDED);
            return;
        }
        this.doTriggerTaskPlugin();
    }

    @Override
    public boolean isStarted() {
        return this.startFlag;
    }

    @Override
    public TaskExecutorState trackTaskExecutorState() {
        TaskExecutorState state = this.taskExecutorState.get();
        if (state.isFinalState()) {
            return state;
        }
        this.latestStateTrackTime = System.currentTimeMillis();
        this.transitTaskExecutorState(this.doTrackTaskPluginStatus());
        return this.taskExecutorState.get();
    }

    @Override
    public long getRemainingTrackDelay() {
        if (this.latestStateTrackTime == 0L) {
            return 0L;
        }
        return this.latestStateTrackTime + 10000L - System.currentTimeMillis();
    }

    @Override
    public TaskExecutorEventBus getTaskExecutorEventBus() {
        return this.taskExecutorEventBus;
    }

    @Override
    public TaskExecutionContext getTaskExecutionContext() {
        return this.taskExecutionContext;
    }

    protected void transitTaskExecutorState(TaskExecutorState taskExecutorState) {
        this.taskExecutorState.set(taskExecutorState);
    }

    protected abstract TaskExecutorState doTrackTaskPluginStatus();

    protected abstract void initializeTaskPlugin();

    protected abstract void doTriggerTaskPlugin();

    protected void initializeTaskContext() {
        this.taskExecutionContext.setStartTime(System.currentTimeMillis());
        log.info(TaskLogMarkers.excludeInTaskLog(), "Initialized taskContext {}", (Object)JSONUtils.toPrettyJsonString((Object)this.taskExecutionContext));
    }

    private void publishTaskRunningEvent() {
        this.transitTaskExecutorState(TaskExecutorState.RUNNING);
        this.taskExecutorEventBus.publish(TaskExecutorStartedLifecycleEvent.of(this));
    }
}

