/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The pod this Toleration is attached to tolerates any taint that matches the triple <key,value,effect> using the matching operator <operator>.")
public class V1Toleration {
    public static final String SERIALIZED_NAME_EFFECT = "effect";
    @SerializedName(value="effect")
    private String effect;
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    private String key;
    public static final String SERIALIZED_NAME_OPERATOR = "operator";
    @SerializedName(value="operator")
    private String operator;
    public static final String SERIALIZED_NAME_TOLERATION_SECONDS = "tolerationSeconds";
    @SerializedName(value="tolerationSeconds")
    private Long tolerationSeconds;
    public static final String SERIALIZED_NAME_VALUE = "value";
    @SerializedName(value="value")
    private String value;

    public V1Toleration effect(String effect) {
        this.effect = effect;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Effect indicates the taint effect to match. Empty means match all taint effects. When specified, allowed values are NoSchedule, PreferNoSchedule and NoExecute.")
    public String getEffect() {
        return this.effect;
    }

    public void setEffect(String effect) {
        this.effect = effect;
    }

    public V1Toleration key(String key) {
        this.key = key;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Key is the taint key that the toleration applies to. Empty means match all taint keys. If the key is empty, operator must be Exists; this combination means to match all values and all keys.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public V1Toleration operator(String operator) {
        this.operator = operator;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Operator represents a key's relationship to the value. Valid operators are Exists and Equal. Defaults to Equal. Exists is equivalent to wildcard for value, so that a pod can tolerate all taints of a particular category.")
    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public V1Toleration tolerationSeconds(Long tolerationSeconds) {
        this.tolerationSeconds = tolerationSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="TolerationSeconds represents the period of time the toleration (which must be of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default, it is not set, which means tolerate the taint forever (do not evict). Zero and negative values will be treated as 0 (evict immediately) by the system.")
    public Long getTolerationSeconds() {
        return this.tolerationSeconds;
    }

    public void setTolerationSeconds(Long tolerationSeconds) {
        this.tolerationSeconds = tolerationSeconds;
    }

    public V1Toleration value(String value) {
        this.value = value;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Value is the taint value the toleration matches to. If the operator is Exists, the value should be empty, otherwise just a regular string.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Toleration v1Toleration = (V1Toleration)o;
        return Objects.equals(this.effect, v1Toleration.effect) && Objects.equals(this.key, v1Toleration.key) && Objects.equals(this.operator, v1Toleration.operator) && Objects.equals(this.tolerationSeconds, v1Toleration.tolerationSeconds) && Objects.equals(this.value, v1Toleration.value);
    }

    public int hashCode() {
        return Objects.hash(this.effect, this.key, this.operator, this.tolerationSeconds, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1Toleration {\n");
        sb.append("    effect: ").append(this.toIndentedString(this.effect)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString(this.operator)).append("\n");
        sb.append("    tolerationSeconds: ").append(this.toIndentedString(this.tolerationSeconds)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

