/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.SparkLinkedServiceTypeProperties;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedService;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.azure.resourcemanager.datafactory.models.SparkAuthenticationType;
import com.azure.resourcemanager.datafactory.models.SparkServerType;
import com.azure.resourcemanager.datafactory.models.SparkThriftTransportProtocol;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="Spark")
public final class SparkLinkedService
extends LinkedService {
    @JsonProperty(value="typeProperties", required=true)
    private SparkLinkedServiceTypeProperties innerTypeProperties = new SparkLinkedServiceTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(SparkLinkedService.class);

    private SparkLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public SparkLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    @Override
    public SparkLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public SparkLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public SparkLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public Object host() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().host();
    }

    public SparkLinkedService withHost(Object host) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SparkLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withHost(host);
        return this;
    }

    public Object port() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().port();
    }

    public SparkLinkedService withPort(Object port) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SparkLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPort(port);
        return this;
    }

    public SparkServerType serverType() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().serverType();
    }

    public SparkLinkedService withServerType(SparkServerType serverType) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SparkLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServerType(serverType);
        return this;
    }

    public SparkThriftTransportProtocol thriftTransportProtocol() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().thriftTransportProtocol();
    }

    public SparkLinkedService withThriftTransportProtocol(SparkThriftTransportProtocol thriftTransportProtocol) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SparkLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withThriftTransportProtocol(thriftTransportProtocol);
        return this;
    }

    public SparkAuthenticationType authenticationType() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().authenticationType();
    }

    public SparkLinkedService withAuthenticationType(SparkAuthenticationType authenticationType) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SparkLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAuthenticationType(authenticationType);
        return this;
    }

    public Object username() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().username();
    }

    public SparkLinkedService withUsername(Object username) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SparkLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUsername(username);
        return this;
    }

    public SecretBase password() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().password();
    }

    public SparkLinkedService withPassword(SecretBase password) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SparkLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPassword(password);
        return this;
    }

    public Object httpPath() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().httpPath();
    }

    public SparkLinkedService withHttpPath(Object httpPath) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SparkLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withHttpPath(httpPath);
        return this;
    }

    public Object enableSsl() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().enableSsl();
    }

    public SparkLinkedService withEnableSsl(Object enableSsl) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SparkLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEnableSsl(enableSsl);
        return this;
    }

    public Object trustedCertPath() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().trustedCertPath();
    }

    public SparkLinkedService withTrustedCertPath(Object trustedCertPath) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SparkLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withTrustedCertPath(trustedCertPath);
        return this;
    }

    public Object useSystemTrustStore() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().useSystemTrustStore();
    }

    public SparkLinkedService withUseSystemTrustStore(Object useSystemTrustStore) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SparkLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUseSystemTrustStore(useSystemTrustStore);
        return this;
    }

    public Object allowHostnameCNMismatch() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().allowHostnameCNMismatch();
    }

    public SparkLinkedService withAllowHostnameCNMismatch(Object allowHostnameCNMismatch) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SparkLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAllowHostnameCNMismatch(allowHostnameCNMismatch);
        return this;
    }

    public Object allowSelfSignedServerCert() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().allowSelfSignedServerCert();
    }

    public SparkLinkedService withAllowSelfSignedServerCert(Object allowSelfSignedServerCert) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SparkLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAllowSelfSignedServerCert(allowSelfSignedServerCert);
        return this;
    }

    public Object encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    public SparkLinkedService withEncryptedCredential(Object encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SparkLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerTypeProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model SparkLinkedService"));
        }
        this.innerTypeProperties().validate();
    }
}

