/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.validator.resource;

import org.apache.dolphinscheduler.api.dto.resources.DeleteResourceDto;
import org.apache.dolphinscheduler.api.validator.resource.AbstractResourceValidator;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.repository.TenantDao;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.springframework.stereotype.Component;

@Component
public class DeleteResourceDtoValidator
extends AbstractResourceValidator<DeleteResourceDto> {
    public DeleteResourceDtoValidator(StorageOperator storageOperator, TenantDao tenantDao) {
        super(storageOperator, tenantDao);
    }

    @Override
    public void validate(DeleteResourceDto deleteResourceDto) {
        String resourceAbsolutePath = deleteResourceDto.getResourceAbsolutePath();
        User loginUser = deleteResourceDto.getLoginUser();
        this.exceptionResourceAbsolutePathInvalidated(resourceAbsolutePath);
        this.exceptionResourceNotExists(resourceAbsolutePath);
        this.exceptionUserNoResourcePermission(loginUser, resourceAbsolutePath);
    }
}

