/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.anttasks;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.anttasks.BaseAntTask;
import org.apache.rat.anttasks.Report;
import org.apache.rat.commandline.Arg;
import org.apache.rat.config.exclusion.StandardCollection;
import org.apache.rat.documentation.options.AbstractOption;
import org.apache.rat.documentation.options.AntOption;
import org.apache.rat.help.AbstractHelp;
import org.apache.rat.utils.DefaultLog;
import org.apache.rat.utils.Log;
import org.apache.tools.ant.Task;

public class Help
extends BaseAntTask {
    public Help() {
        Log oldLog = DefaultLog.getInstance();
        if (oldLog instanceof DefaultLog) {
            DefaultLog.setInstance(new Logger());
            DefaultLog.getInstance().setLevel(oldLog.getLevel());
        }
    }

    public void execute() {
        org.apache.rat.help.Help helpObj = new org.apache.rat.help.Help(System.out){

            @Override
            public void printUsage(Options opts) {
                String syntax = "ant {target executing task <rat:help/>}";
                AntHelpFormatter helpFormatter = new AntHelpFormatter();
                helpFormatter.setOptPrefix("<");
                helpFormatter.printHelp(this.writer, helpFormatter.getWidth(), syntax, AbstractHelp.header("Available options"), opts, helpFormatter.getLeftPadding(), helpFormatter.getDescPadding(), 1.header("Argument Types"));
                String argumentPadding = this.printArgumentTypes();
                this.writer.println(1.header("Standard Collections"));
                for (StandardCollection sc : StandardCollection.values()) {
                    this.writer.format("%n<%s>%n", sc.name());
                    helpFormatter.printWrapped(this.writer, helpFormatter.getWidth(), helpFormatter.getLeftPadding() + 4 + 4, argumentPadding + sc.desc());
                    helpFormatter.printWrapped(this.writer, helpFormatter.getWidth(), helpFormatter.getLeftPadding() + 4 + 4, argumentPadding + "File patterns: " + (sc.patterns().isEmpty() ? "<none>" : String.join((CharSequence)", ", sc.patterns())));
                    helpFormatter.printWrapped(this.writer, helpFormatter.getWidth(), helpFormatter.getLeftPadding() + 4 + 4, argumentPadding + "Provides a path matcher: " + sc.hasStaticDocumentNameMatcher());
                    helpFormatter.printWrapped(this.writer, helpFormatter.getWidth(), helpFormatter.getLeftPadding() + 4 + 4, argumentPadding + "Provides a file processor: " + sc.fileProcessorBuilder().hasNext());
                }
                this.writer.println("\nA path matcher will match specific information about the file.");
                this.writer.println("\nA file processor will process the associated \"ignore\" file for include and exclude directives");
                this.writer.println(1.header("Notes"));
                int idx = 1;
                for (String note : NOTES) {
                    this.writer.format("%d. %s%n", idx++, note);
                }
                this.writer.flush();
            }
        };
        helpObj.printUsage(Arg.getOptions());
    }

    public void log(String msg, int msgLevel) {
        if (this.getProject() != null) {
            this.getProject().log(msg, msgLevel);
        } else {
            DefaultLog.createDefault().log(Report.fromProjectLevel(msgLevel), msg);
        }
    }

    public void log(String msg, Throwable t, int msgLevel) {
        if (this.getProject() == null) {
            this.log(Log.formatLogEntry(msg, t), msgLevel);
        } else {
            this.getProject().log((Task)this, msg, t, msgLevel);
        }
    }

    private final class Logger
    implements Log {
        private Logger() {
        }

        @Override
        public Log.Level getLevel() {
            return Log.Level.DEBUG;
        }

        @Override
        public void log(Log.Level level, String message, Throwable throwable) {
            this.log(level, Log.formatLogEntry(message, throwable));
        }

        @Override
        public void log(Log.Level level, String msg) {
            Help.this.log(msg, Report.toProjectLevel(level));
        }
    }

    public static class AntHelpFormatter
    extends HelpFormatter {
        public AntHelpFormatter() {
            this.setWidth(180);
        }

        @Override
        public Comparator<Option> getOptionComparator() {
            return Comparator.comparing(Option::getLongOpt);
        }

        @Override
        protected StringBuffer renderOptions(StringBuffer sb, int width, Options options, int leftPad, int descPad) {
            String example;
            String lpad = this.createPadding(leftPad);
            String dpad = this.createPadding(descPad);
            String optionTitle = " -- Option --";
            String exampleTitle = " -- Example --";
            String descriptionTitle = " -- Description --";
            int max = optionTitle.length();
            int maxExample = exampleTitle.length();
            List optList = options.getOptions().stream().filter(Option::hasLongOpt).map(AntOption::new).collect(Collectors.toList());
            if (this.getOptionComparator() != null) {
                optList.sort(Comparator.comparing(AbstractOption::getName));
            }
            ArrayList<String> exampleList = new ArrayList<String>();
            for (AntOption option : optList) {
                String argName = StringUtils.defaultIfEmpty(option.getArgName(), "value");
                String fmt = option.isAttribute() ? "<rat:report %s='%s'>" : "<%1$s>%2$s</%1$s>";
                example = String.format(fmt, option.getName(), argName);
                exampleList.add(example);
                max = Math.max(option.cleanupName().length(), max);
                maxExample = Math.max(example.length(), maxExample);
            }
            sb.append(optionTitle).append(this.createPadding(max - optionTitle.length())).append(dpad).append(exampleTitle).append(this.createPadding(maxExample - exampleTitle.length())).append(dpad).append(descriptionTitle).append(this.getNewLine());
            int x = 0;
            Iterator it = optList.iterator();
            while (it.hasNext()) {
                AntOption option = (AntOption)it.next();
                String name = option.cleanupName();
                example = (String)exampleList.get(x++);
                StringBuilder optBuf = new StringBuilder(name);
                if (name.length() < max) {
                    optBuf.append(this.createPadding(max - name.length()));
                }
                optBuf.append(dpad).append(example);
                if (example.length() < maxExample) {
                    optBuf.append(this.createPadding(maxExample - example.length()));
                }
                optBuf.append(dpad);
                int nextLineTabStop = max + maxExample + 2 * descPad;
                if (option.isDeprecated()) {
                    optBuf.append(option.getDeprecated());
                } else if (option.getDescription() != null) {
                    optBuf.append(option.getDescription());
                }
                this.renderWrappedText(sb, width, nextLineTabStop, optBuf.toString());
                if (!it.hasNext()) continue;
                sb.append(this.getNewLine());
            }
            return sb;
        }
    }
}

