/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.input.CharSequenceInputStream;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.io.input.WindowsLineEndingInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class WindowsLineEndingInputStreamTest {
    WindowsLineEndingInputStreamTest() {
    }

    private String roundtripReadByte(String msg) throws IOException {
        return this.roundtripReadByte(msg, true);
    }

    private String roundtripReadByte(String msg, boolean ensure) throws IOException {
        try (WindowsLineEndingInputStream lf = new WindowsLineEndingInputStream((InputStream)((CharSequenceInputStream.Builder)CharSequenceInputStream.builder().setCharSequence((CharSequence)msg)).setCharset(StandardCharsets.UTF_8).get(), ensure);){
            int read;
            byte[] buf = new byte[100];
            int i = 0;
            while (i < buf.length && (read = lf.read()) >= 0) {
                buf[i++] = (byte)read;
            }
            String string = new String(buf, 0, i, StandardCharsets.UTF_8);
            return string;
        }
    }

    private String roundtripReadByteArray(String msg) throws IOException {
        return this.roundtripReadByteArray(msg, true);
    }

    private String roundtripReadByteArray(String msg, boolean ensure) throws IOException {
        try (WindowsLineEndingInputStream lf = new WindowsLineEndingInputStream((InputStream)((CharSequenceInputStream.Builder)CharSequenceInputStream.builder().setCharSequence((CharSequence)msg)).setCharset(StandardCharsets.UTF_8).get(), ensure);){
            byte[] buf = new byte[100];
            int read = lf.read(buf);
            String string = new String(buf, 0, read, StandardCharsets.UTF_8);
            return string;
        }
    }

    private String roundtripReadByteArrayIndex(String msg) throws IOException {
        return this.roundtripReadByteArrayIndex(msg, true);
    }

    private String roundtripReadByteArrayIndex(String msg, boolean ensure) throws IOException {
        try (WindowsLineEndingInputStream lf = new WindowsLineEndingInputStream((InputStream)((CharSequenceInputStream.Builder)CharSequenceInputStream.builder().setCharSequence((CharSequence)msg)).setCharset(StandardCharsets.UTF_8).get(), ensure);){
            byte[] buf = new byte[100];
            int read = lf.read(buf, 0, 100);
            String string = new String(buf, 0, read, StandardCharsets.UTF_8);
            return string;
        }
    }

    @Test
    void testInTheMiddleOfTheLine_Byte() throws Exception {
        Assertions.assertEquals((Object)"a\r\nbc\r\n", (Object)this.roundtripReadByte("a\r\nbc"));
    }

    @Test
    void testInTheMiddleOfTheLine_ByteArray() throws Exception {
        Assertions.assertEquals((Object)"a\r\nbc\r\n", (Object)this.roundtripReadByteArray("a\r\nbc"));
    }

    @Test
    void testInTheMiddleOfTheLine_ByteArrayIndex() throws Exception {
        Assertions.assertEquals((Object)"a\r\nbc\r\n", (Object)this.roundtripReadByteArrayIndex("a\r\nbc"));
    }

    @Test
    void testLinuxLineFeeds_Byte() throws Exception {
        Assertions.assertEquals((Object)"ab\r\nc", (Object)this.roundtripReadByte("ab\nc", false));
    }

    @Test
    void testLinuxLineFeeds_ByteArray() throws Exception {
        Assertions.assertEquals((Object)"ab\r\nc", (Object)this.roundtripReadByteArray("ab\nc", false));
    }

    @Test
    void testLinuxLineFeeds_ByteArrayIndex() throws Exception {
        Assertions.assertEquals((Object)"ab\r\nc", (Object)this.roundtripReadByteArrayIndex("ab\nc", false));
    }

    @Test
    void testMalformed_Byte() throws Exception {
        Assertions.assertEquals((Object)"a\rbc", (Object)this.roundtripReadByte("a\rbc", false));
    }

    @Test
    void testMalformed_ByteArray() throws Exception {
        Assertions.assertEquals((Object)"a\rbc", (Object)this.roundtripReadByteArray("a\rbc", false));
    }

    @Test
    void testMalformed_ByteArrayIndex() throws Exception {
        Assertions.assertEquals((Object)"a\rbc", (Object)this.roundtripReadByteArrayIndex("a\rbc", false));
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    void testMark(boolean ensureLineFeedAtEndOfFile) {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> new WindowsLineEndingInputStream((InputStream)new NullInputStream(), true).mark(1));
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    void testMarkSupported(boolean ensureLineFeedAtEndOfFile) {
        Assertions.assertFalse((boolean)new WindowsLineEndingInputStream((InputStream)new NullInputStream(), true).markSupported());
    }

    @Test
    void testMultipleBlankLines_Byte() throws Exception {
        Assertions.assertEquals((Object)"a\r\n\r\nbc\r\n", (Object)this.roundtripReadByte("a\r\n\r\nbc"));
    }

    @Test
    void testMultipleBlankLines_ByteArray() throws Exception {
        Assertions.assertEquals((Object)"a\r\n\r\nbc\r\n", (Object)this.roundtripReadByteArray("a\r\n\r\nbc"));
    }

    @Test
    void testMultipleBlankLines_ByteArrayIndex() throws Exception {
        Assertions.assertEquals((Object)"a\r\n\r\nbc\r\n", (Object)this.roundtripReadByteArrayIndex("a\r\n\r\nbc"));
    }

    @Test
    void testRetainLineFeed_Byte() throws Exception {
        Assertions.assertEquals((Object)"a\r\n\r\n", (Object)this.roundtripReadByte("a\r\n\r\n", false));
        Assertions.assertEquals((Object)"a", (Object)this.roundtripReadByte("a", false));
    }

    @Test
    void testRetainLineFeed_ByteArray() throws Exception {
        Assertions.assertEquals((Object)"a\r\n\r\n", (Object)this.roundtripReadByteArray("a\r\n\r\n", false));
        Assertions.assertEquals((Object)"a", (Object)this.roundtripReadByteArray("a", false));
    }

    @Test
    void testRetainLineFeed_ByteArrayIndex() throws Exception {
        Assertions.assertEquals((Object)"a\r\n\r\n", (Object)this.roundtripReadByteArray("a\r\n\r\n", false));
        Assertions.assertEquals((Object)"a", (Object)this.roundtripReadByteArrayIndex("a", false));
    }

    @Test
    void testSimpleString_Byte() throws Exception {
        Assertions.assertEquals((Object)"abc\r\n", (Object)this.roundtripReadByte("abc"));
    }

    @Test
    void testSimpleString_ByteArray() throws Exception {
        Assertions.assertEquals((Object)"abc\r\n", (Object)this.roundtripReadByteArray("abc"));
    }

    @Test
    void testSimpleString_ByteArrayIndex() throws Exception {
        Assertions.assertEquals((Object)"abc\r\n", (Object)this.roundtripReadByteArrayIndex("abc"));
    }

    @Test
    void testTwoLinesAtEnd_Byte() throws Exception {
        Assertions.assertEquals((Object)"a\r\n\r\n", (Object)this.roundtripReadByte("a\r\n\r\n"));
    }

    @Test
    void testTwoLinesAtEnd_ByteArray() throws Exception {
        Assertions.assertEquals((Object)"a\r\n\r\n", (Object)this.roundtripReadByteArray("a\r\n\r\n"));
    }

    @Test
    void testTwoLinesAtEnd_ByteArrayIndex() throws Exception {
        Assertions.assertEquals((Object)"a\r\n\r\n", (Object)this.roundtripReadByteArrayIndex("a\r\n\r\n"));
    }
}

