/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink.network;

import java.nio.charset.StandardCharsets;
import org.apache.celeborn.common.network.buffer.NettyManagedBuffer;
import org.apache.celeborn.common.network.protocol.BacklogAnnouncement;
import org.apache.celeborn.common.network.protocol.BufferStreamEnd;
import org.apache.celeborn.common.network.protocol.Heartbeat;
import org.apache.celeborn.common.network.protocol.Message;
import org.apache.celeborn.common.network.protocol.OneWayMessage;
import org.apache.celeborn.common.network.protocol.ReadAddCredit;
import org.apache.celeborn.common.network.protocol.RpcFailure;
import org.apache.celeborn.common.network.protocol.RpcRequest;
import org.apache.celeborn.common.network.protocol.RpcResponse;
import org.apache.celeborn.common.network.protocol.TransportableError;
import org.apache.celeborn.plugin.flink.buffer.FlinkNettyManagedBuffer;
import org.apache.celeborn.plugin.flink.protocol.ReadData;
import org.apache.celeborn.plugin.flink.protocol.SubPartitionReadData;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;

public class MessageDecoderExt {
    public static Message decode(Message.Type type, ByteBuf in, boolean decodeBody) {
        switch (type) {
            case RPC_REQUEST: {
                long requestId = in.readLong();
                in.readInt();
                if (decodeBody) {
                    return new RpcRequest(requestId, new FlinkNettyManagedBuffer(in));
                }
                return new RpcRequest(requestId, NettyManagedBuffer.EmptyBuffer);
            }
            case RPC_RESPONSE: {
                long requestId = in.readLong();
                in.readInt();
                if (decodeBody) {
                    return new RpcResponse(requestId, new FlinkNettyManagedBuffer(in));
                }
                return new RpcResponse(requestId, NettyManagedBuffer.EmptyBuffer);
            }
            case RPC_FAILURE: {
                long requestId = in.readLong();
                int length = in.readInt();
                byte[] bytes = new byte[length];
                in.readBytes(bytes);
                String errorString = new String(bytes, StandardCharsets.UTF_8);
                return new RpcFailure(requestId, errorString);
            }
            case ONE_WAY_MESSAGE: {
                in.readInt();
                if (decodeBody) {
                    return new OneWayMessage(new FlinkNettyManagedBuffer(in));
                }
                return new OneWayMessage(NettyManagedBuffer.EmptyBuffer);
            }
            case READ_ADD_CREDIT: {
                long streamId = in.readLong();
                int credit = in.readInt();
                return new ReadAddCredit(streamId, credit);
            }
            case READ_DATA: {
                long streamId = in.readLong();
                return new ReadData(streamId);
            }
            case SUBPARTITION_READ_DATA: {
                long streamId = in.readLong();
                int subPartitionId = in.readInt();
                return new SubPartitionReadData(streamId, subPartitionId);
            }
            case BACKLOG_ANNOUNCEMENT: {
                long streamId = in.readLong();
                int backlog = in.readInt();
                return new BacklogAnnouncement(streamId, backlog);
            }
            case TRANSPORTABLE_ERROR: {
                long streamId = in.readLong();
                int len = in.readInt();
                byte[] errorBytes = new byte[len];
                in.readBytes(errorBytes);
                return new TransportableError(streamId, errorBytes);
            }
            case HEARTBEAT: {
                return new Heartbeat();
            }
            case BUFFER_STREAM_END: {
                long streamId = in.readLong();
                return new BufferStreamEnd(streamId);
            }
        }
        throw new IllegalArgumentException("Unexpected message type: " + type);
    }
}

