/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.meta;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.common.meta.FileMeta;
import org.apache.celeborn.common.meta.ReduceFileMeta;

public abstract class FileInfo {
    private final UserIdentifier userIdentifier;
    private boolean partitionSplitEnabled;
    protected FileMeta fileMeta;
    protected final Set<Long> streams = ConcurrentHashMap.newKeySet();
    protected volatile long bytesFlushed;
    private boolean isReduceFileMeta;

    public FileInfo(UserIdentifier userIdentifier, boolean partitionSplitEnabled, FileMeta fileMeta) {
        this.userIdentifier = userIdentifier;
        this.partitionSplitEnabled = partitionSplitEnabled;
        this.fileMeta = fileMeta;
        this.isReduceFileMeta = fileMeta instanceof ReduceFileMeta;
    }

    public void replaceFileMeta(FileMeta meta) {
        this.fileMeta = meta;
        this.isReduceFileMeta = meta instanceof ReduceFileMeta;
    }

    public FileMeta getFileMeta() {
        return this.fileMeta;
    }

    public ReduceFileMeta getReduceFileMeta() {
        return (ReduceFileMeta)this.fileMeta;
    }

    public long getFileLength() {
        return this.bytesFlushed;
    }

    public synchronized void updateBytesFlushed(long bytes) {
        this.bytesFlushed += bytes;
        if (this.isReduceFileMeta) {
            this.getReduceFileMeta().updateChunkOffset(this.bytesFlushed, false);
        }
    }

    public UserIdentifier getUserIdentifier() {
        return this.userIdentifier;
    }

    public boolean isPartitionSplitEnabled() {
        return this.partitionSplitEnabled;
    }

    public void setPartitionSplitEnabled(boolean partitionSplitEnabled) {
        this.partitionSplitEnabled = partitionSplitEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addStream(long streamId) {
        if (!this.isReduceFileMeta) {
            throw new IllegalStateException("In addStream, filemeta cannot be MapFileMeta");
        }
        AtomicBoolean atomicBoolean = this.getReduceFileMeta().getSorted();
        synchronized (atomicBoolean) {
            if (this.getReduceFileMeta().getSorted().get()) {
                return false;
            }
            this.streams.add(streamId);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeStream(long streamId) {
        if (!this.isReduceFileMeta) {
            throw new IllegalStateException("In closeStream, filemeta cannot be MapFileMeta");
        }
        AtomicBoolean atomicBoolean = this.getReduceFileMeta().getSorted();
        synchronized (atomicBoolean) {
            this.streams.remove(streamId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStreamsEmpty() {
        if (!this.isReduceFileMeta) {
            throw new IllegalStateException("In isStreamsEmpty, filemeta cannot be MapFileMeta");
        }
        AtomicBoolean atomicBoolean = this.getReduceFileMeta().getSorted();
        synchronized (atomicBoolean) {
            return this.streams.isEmpty();
        }
    }

    public abstract String getFilePath();
}

