/*
 * Decompiled with CFR 0.152.
 */
package org.perfkit.sjk.jfr.mcparser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.gridkit.jvmtool.spi.parsers.InputStreamSource;
import org.gridkit.jvmtool.spi.parsers.JsonEventDumpParser;
import org.gridkit.jvmtool.spi.parsers.JsonEventDumpParserFactory;
import org.gridkit.jvmtool.spi.parsers.JsonEventSource;
import org.gridkit.jvmtool.util.json.JsonStreamWriter;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.flightrecorder.internal.EventArray;
import org.perfkit.sjk.jfr.mcparser.IOHelper;
import org.perfkit.sjk.jfr.mcparser.JFRLoader;
import org.perfkit.sjk.jfr.mcparser.JsonEventAdapter;

public class JsonFlightRecordingParserFactory
implements JsonEventDumpParserFactory {
    @Override
    public JsonEventDumpParser createParser(Map<String, String> options) throws Exception {
        Parser parser = new Parser();
        parser.configure(options);
        return parser;
    }

    private static class EventSource
    implements JsonEventSource {
        private final List<IItem> items;
        private final JsonEventAdapter adapter;
        private int n;

        public EventSource(List<IItem> items, int maxJsonDepth) {
            this.items = items;
            this.adapter = new JsonEventAdapter(maxJsonDepth);
        }

        public void setWhiteList(Collection<String> list) {
            this.adapter.setWhiteList(list);
        }

        public void setBlackList(Collection<String> list) {
            this.adapter.setBlackList(list);
        }

        @Override
        public boolean readNext(JsonStreamWriter writer) throws IOException {
            IItem it;
            do {
                if (this.n >= this.items.size()) {
                    return false;
                }
                it = this.items.get(this.n);
                ++this.n;
            } while (!this.adapter.encodeEvent(it, writer));
            return true;
        }
    }

    private static class Parser
    implements JsonEventDumpParser {
        private int jsonMaxDepth = Integer.MAX_VALUE;
        private List<String> whiteList = null;
        private List<String> blackList = null;

        private Parser() {
        }

        @Override
        public JsonEventSource open(InputStreamSource source) throws Exception {
            EventArray[] events = JFRLoader.loadStream(IOHelper.openFlatOrCommpressedStream(source), false, true);
            ArrayList<IItem> items = new ArrayList<IItem>();
            for (EventArray a : events) {
                for (IItem i : a.getEvents()) {
                    items.add(i);
                }
            }
            EventSource eventSource = new EventSource(items, this.jsonMaxDepth);
            if (this.whiteList != null) {
                eventSource.setWhiteList(this.whiteList);
            }
            if (this.blackList != null) {
                eventSource.setBlackList(this.blackList);
            }
            return eventSource;
        }

        public void configure(Map<String, String> options) {
            for (String key : options.keySet()) {
                String[] list;
                if ("jfr.native_parser".equals(key)) {
                    if ("false".equalsIgnoreCase(options.get(key))) continue;
                    throw new RuntimeException("Unsatisfied option: " + key + "=" + options.get(key));
                }
                if ("json.max_depth".equals(key)) {
                    this.jsonMaxDepth = Integer.valueOf(options.get(key));
                    if (this.jsonMaxDepth >= 0) continue;
                    throw new RuntimeException("Illegal option value: " + key + "=" + options.get(key));
                }
                if ("jfr.blacklist".equals(key)) {
                    list = options.get(key).split(",");
                    if (list.length <= 0) continue;
                    this.blackList = Arrays.asList(list);
                    continue;
                }
                if ("jfr.whitelist".equals(key)) {
                    list = options.get(key).split(",");
                    if (list.length <= 0) continue;
                    this.whiteList = Arrays.asList(list);
                    continue;
                }
                throw new RuntimeException("Unknown option: " + key + "=" + options.get(key));
            }
        }
    }
}

