/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace.analytics;

import java.util.HashMap;
import java.util.Map;
import org.gridkit.jvmtool.stacktrace.ThreadSnapshot;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadDumpAggregator;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadDumpAggregatorFactory;

class CpuAggregatorFactory
implements ThreadDumpAggregator,
ThreadDumpAggregatorFactory {
    private Map<Long, ThreadTrack> info = new HashMap<Long, ThreadTrack>();

    CpuAggregatorFactory() {
    }

    @Override
    public ThreadDumpAggregator newInstance() {
        return new CpuAggregatorFactory();
    }

    @Override
    public void aggregate(ThreadSnapshot threadInfo) {
        if (threadInfo.counters().getValue("java.cpu-time.ms") != Long.MIN_VALUE) {
            ThreadTrack tt = this.info.get(threadInfo.threadId());
            if (tt == null) {
                tt = new ThreadTrack();
                tt.firstTimestamp = threadInfo.timestamp();
                tt.lastTimestamp = threadInfo.timestamp();
                tt.fisrtCPU = threadInfo.counters().getValue("java.cpu-time.ms");
                tt.lastCPU = threadInfo.counters().getValue("java.cpu-time.ms");
                this.info.put(threadInfo.threadId(), tt);
            } else {
                if (tt.firstTimestamp > threadInfo.timestamp()) {
                    tt.firstTimestamp = threadInfo.timestamp();
                    tt.fisrtCPU = threadInfo.counters().getValue("java.cpu-time.ms");
                }
                if (tt.lastTimestamp < threadInfo.timestamp()) {
                    tt.lastTimestamp = threadInfo.timestamp();
                    tt.lastCPU = threadInfo.counters().getValue("java.cpu-time.ms");
                }
            }
        }
    }

    @Override
    public Object info() {
        long totalCPU = 0L;
        long minTs = Long.MAX_VALUE;
        long maxTs = Long.MIN_VALUE;
        for (ThreadTrack tt : this.info.values()) {
            totalCPU += tt.lastCPU - tt.fisrtCPU;
            minTs = Math.min(minTs, tt.firstTimestamp);
            maxTs = Math.max(maxTs, tt.lastTimestamp);
        }
        if (minTs == Long.MAX_VALUE || minTs == maxTs) {
            return Double.NaN;
        }
        return (double)totalCPU / (double)(maxTs - minTs);
    }

    private static class ThreadTrack {
        long firstTimestamp;
        long fisrtCPU;
        long lastTimestamp;
        long lastCPU;

        private ThreadTrack() {
        }
    }
}

