/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace;

import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import org.gridkit.jvmtool.codec.stacktrace.ThreadSnapshotEvent;
import org.gridkit.jvmtool.codec.stacktrace.ThreadSnapshotEventPojo;
import org.gridkit.jvmtool.codec.stacktrace.ThreadTraceEvent;
import org.gridkit.jvmtool.event.Event;
import org.gridkit.jvmtool.event.MultiCounterEvent;
import org.gridkit.jvmtool.event.SimpleTagCollection;
import org.gridkit.jvmtool.event.TagCollection;
import org.gridkit.jvmtool.event.TaggedEvent;
import org.gridkit.jvmtool.event.TimestampedEvent;
import org.gridkit.jvmtool.event.UniversalEventWriter;
import org.gridkit.jvmtool.stacktrace.CounterCollection;
import org.gridkit.jvmtool.stacktrace.DataBuffer;
import org.gridkit.jvmtool.stacktrace.RotatingStringDictionary;
import org.gridkit.jvmtool.stacktrace.StackFrame;
import org.gridkit.jvmtool.stacktrace.StackFrameList;
import org.gridkit.jvmtool.stacktrace.StackTraceCodec;
import org.gridkit.jvmtool.stacktrace.TagDictionary;

class StackTraceEventWriterV4
implements UniversalEventWriter {
    private DataOutputStream dos;
    private Map<String, Integer> stringDic = new HashMap<String, Integer>();
    private RotatingStringDictionary dynDic = new RotatingStringDictionary(512);
    private TagDictionary tagSetDic;
    private TagDictionary counterSetDic;
    private Map<StackFrame, Integer> frameDic;
    private TagEncoder encoder;
    private TagEncoder counterTagEncoder;
    private SimpleTagCollection tagBuilder;
    private SimpleTagCollection counterBuilder;
    private int counterSetRef;
    private ThreadSnapshotEventPojo eventBuf;

    public StackTraceEventWriterV4(OutputStream os) throws IOException {
        for (String s2 : StackTraceCodec.PRESET_TAG_KEY_V4) {
            this.stringDic.put(s2, this.stringDic.size() + 1);
        }
        for (String s2 : StackTraceCodec.PRESET_TAG_TAG_V4) {
            this.dynDic.intern(s2);
        }
        this.tagSetDic = new TagDictionary(4096);
        this.counterSetDic = new TagDictionary(512);
        this.frameDic = new HashMap<StackFrame, Integer>();
        this.encoder = new TagEncoder();
        this.counterTagEncoder = new CounterTagEncoder();
        this.tagBuilder = new SimpleTagCollection();
        this.counterBuilder = new SimpleTagCollection();
        this.eventBuf = new ThreadSnapshotEventPojo();
        DeflaterOutputStream def = new DeflaterOutputStream(os);
        this.dos = new DataOutputStream(new BufferedOutputStream(def, 32768));
    }

    @Override
    public synchronized void store(Event event) throws IOException {
        try {
            if (event instanceof Error) {
                throw new IllegalArgumentException();
            }
            if (event instanceof ThreadSnapshotEvent) {
                this.copyToBuf((ThreadSnapshotEvent)event);
                this.storeThreadEvent(this.eventBuf);
            } else if (event instanceof ThreadTraceEvent) {
                this.storeThreadEvent((ThreadTraceEvent)event);
            } else {
                this.storeCommonEvent(event);
            }
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
        catch (RuntimeException e) {
            this.close();
            throw e;
        }
    }

    private void copyToBuf(ThreadSnapshotEvent event) {
        this.eventBuf.loadFrom(event);
        if (event.threadId() >= 0L) {
            this.eventBuf.counters().set("thread.javaId", event.threadId());
        }
        if (event.threadName() != null) {
            this.eventBuf.tags().remove("thread.javaName");
            this.eventBuf.tags().put("thread.javaName", event.threadName());
        }
        if (event.threadState() != null) {
            this.eventBuf.tags().remove("thread.javaState");
            this.eventBuf.tags().put("thread.javaState", event.threadState().toString());
        }
    }

    protected void storeThreadEvent(ThreadTraceEvent snap) throws IOException {
        TagCollection stags = snap instanceof TaggedEvent ? ((TaggedEvent)((Object)snap)).tags() : null;
        CounterCollection scc = snap instanceof MultiCounterEvent ? ((MultiCounterEvent)((Object)snap)).counters() : null;
        this.tagBuilder.clear();
        this.markTags();
        long timestamp = -1L;
        if (snap instanceof TimestampedEvent) {
            this.markTimestamp();
            timestamp = ((TimestampedEvent)((Object)snap)).timestamp();
        }
        if (snap.stackTrace() != null) {
            this.markThreadStackTrace();
            for (StackFrame ste : snap.stackTrace()) {
                this.intern(ste);
            }
        }
        if (scc != null) {
            this.ensureCounters(scc);
        }
        int tagSetId = this.ensureTagSet(stags);
        this.dos.writeByte(3);
        StackTraceCodec.writeVarInt(this.dos, tagSetId);
        this.writeTimestamp(timestamp);
        this.writeCounters(scc);
        this.writeTrace(snap.stackTrace());
    }

    protected void storeCommonEvent(Event snap) throws IOException {
        this.tagBuilder.clear();
        this.markTags();
        long timestamp = -1L;
        if (snap instanceof TimestampedEvent) {
            this.markTimestamp();
            timestamp = ((TimestampedEvent)((Object)snap)).timestamp();
        }
        CounterCollection counters = null;
        if (snap instanceof MultiCounterEvent) {
            this.ensureCounters(((MultiCounterEvent)snap).counters());
            counters = ((MultiCounterEvent)snap).counters();
        }
        int tagSetId = snap instanceof TaggedEvent ? this.ensureTagSet(((TaggedEvent)snap).tags()) : this.ensureTagSet(new SimpleTagCollection());
        this.dos.writeByte(3);
        StackTraceCodec.writeVarInt(this.dos, tagSetId);
        this.writeTimestamp(timestamp);
        this.writeCounters(counters);
    }

    private void writeTimestamp(long timestamp) throws IOException {
        if (this.hasTimestampMark()) {
            StackTraceCodec.writeTimestamp(this.dos, timestamp);
        }
    }

    private void writeCounters(CounterCollection counters) throws IOException {
        if (this.hasCountersMark()) {
            StackTraceCodec.writeVarInt(this.dos, this.counterSetRef);
            for (String key : this.counterBuilder) {
                long v = counters.getValue(key);
                StackTraceCodec.writeVarLong(this.dos, v);
            }
        }
    }

    private void writeTrace(StackFrameList trace) throws IOException {
        if (this.hasStackTraceMark()) {
            int n = 0;
            for (StackFrame sf : trace) {
                ++n;
            }
            StackTraceCodec.writeVarInt(this.dos, n);
            for (StackFrame ste : trace) {
                StackTraceCodec.writeVarInt(this.dos, this.intern(ste));
            }
        }
    }

    private int intern(String str) throws IOException {
        if (str == null) {
            return 0;
        }
        if (!this.stringDic.containsKey(str)) {
            this.dos.write(1);
            this.dos.writeUTF(str);
            int n = this.stringDic.size() + 1;
            this.stringDic.put(str, n);
        }
        return this.stringDic.get(str);
    }

    private int internDyn(String str) throws IOException {
        if (str == null) {
            return 0;
        }
        int n = this.dynDic.intern(str);
        if (n < 0) {
            this.dos.write(4);
            StackTraceCodec.writeVarInt(this.dos, (n ^= 0xFFFFFFFF) + 1);
            this.dos.writeUTF(str);
        }
        return ++n;
    }

    private int intern(StackFrame ste) throws IOException {
        if (!this.frameDic.containsKey(ste)) {
            String pkg = ste.getClassName();
            int c = pkg.lastIndexOf(46);
            String cn = c < 0 ? pkg : pkg.substring(c + 1);
            pkg = c < 0 ? null : pkg.substring(0, c);
            String mtd = ste.getMethodName();
            String file = ste.getSourceFile();
            int line = ste.getLineNumber() + 2;
            if (line < 0) {
                line = 0;
            }
            int npkg = this.intern(pkg);
            int ncn = this.intern(cn);
            int nmtd = this.intern(mtd);
            int nfile = this.intern(file);
            this.dos.writeByte(2);
            StackTraceCodec.writeVarInt(this.dos, npkg);
            StackTraceCodec.writeVarInt(this.dos, ncn);
            StackTraceCodec.writeVarInt(this.dos, nmtd);
            StackTraceCodec.writeVarInt(this.dos, nfile);
            StackTraceCodec.writeVarInt(this.dos, line);
            int n = this.frameDic.size() + 1;
            this.frameDic.put(ste, n);
        }
        return this.frameDic.get(ste);
    }

    private int ensureTagSet(TagCollection tags) throws IOException {
        try {
            if (tags != null) {
                for (String key : tags) {
                    if ("(stored-parts)".equals(key)) continue;
                    for (String tag : tags.tagsFor(key)) {
                        this.tagBuilder.put(key, tag);
                    }
                }
            }
            int tagSetId = this.tagSetDic.intern(this.tagBuilder, this.encoder);
            return tagSetId;
        }
        catch (CapsuleException e) {
            throw this.uncapsuleExcepion(e);
        }
    }

    private void ensureCounters(CounterCollection counters) throws IOException {
        try {
            Iterator it;
            this.counterSetRef = -1;
            if (counters != null && (it = counters.iterator()).hasNext()) {
                this.markCounters();
                this.counterBuilder.clear();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    if (counters.getValue(key) < 0L) continue;
                    this.counterBuilder.put(key, "");
                }
                this.counterSetRef = this.counterSetDic.intern(this.counterBuilder, this.counterTagEncoder);
                return;
            }
        }
        catch (CapsuleException e) {
            throw this.uncapsuleExcepion(e);
        }
    }

    protected IOException uncapsuleExcepion(CapsuleException e) throws IOException {
        if (e.getCause() instanceof IOException) {
            throw (IOException)e.getCause();
        }
        if (e.getCause() instanceof RuntimeException) {
            throw (RuntimeException)e.getCause();
        }
        throw new IOException(e.getCause());
    }

    protected void markTimestamp() {
        this.tagBuilder.put("(stored-parts)", "timestamp");
    }

    protected void markCounters() {
        this.tagBuilder.put("(stored-parts)", "counters");
    }

    protected void markTags() {
        this.tagBuilder.put("(stored-parts)", "tags");
    }

    protected void markThreadStackTrace() {
        this.tagBuilder.put("(stored-parts)", "thread-stack");
    }

    protected boolean hasTimestampMark() {
        return this.tagBuilder.contains("(stored-parts)", "timestamp");
    }

    protected boolean hasCountersMark() {
        return this.tagBuilder.contains("(stored-parts)", "counters");
    }

    protected boolean hasStackTraceMark() {
        return this.tagBuilder.contains("(stored-parts)", "thread-stack");
    }

    @Override
    public synchronized void close() {
        try {
            this.dos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.stringDic.clear();
        this.frameDic.clear();
    }

    private static class CapsuleException
    extends RuntimeException {
        private static final long serialVersionUID = 20161218L;

        public CapsuleException(Throwable cause) {
            super(cause);
        }
    }

    private class CounterTagEncoder
    extends TagEncoder {
        private CounterTagEncoder() {
        }

        @Override
        protected int startTag() {
            return 5;
        }
    }

    private class TagChange {
        int op;
        String key;
        String tag;

        public TagChange(int op, String key, String tag) {
            this.op = op;
            this.key = key;
            this.tag = tag;
        }

        public void encode(DataOutput out) throws IOException {
            switch (this.op) {
                case 2: {
                    out.writeByte(2);
                    StackTraceCodec.writeVarInt(out, StackTraceEventWriterV4.this.intern(this.key));
                    break;
                }
                case 1: {
                    out.writeByte(1);
                    StackTraceCodec.writeVarInt(out, StackTraceEventWriterV4.this.intern(this.key));
                    StackTraceCodec.writeVarInt(out, StackTraceEventWriterV4.this.internDyn(this.tag));
                    break;
                }
                case 3: {
                    out.writeByte(3);
                    StackTraceCodec.writeVarInt(out, StackTraceEventWriterV4.this.intern(this.key));
                    StackTraceCodec.writeVarInt(out, StackTraceEventWriterV4.this.internDyn(this.tag));
                    break;
                }
                case 4: {
                    out.writeByte(4);
                    StackTraceCodec.writeVarInt(out, StackTraceEventWriterV4.this.intern(this.key));
                    break;
                }
                case 5: {
                    out.writeByte(5);
                    StackTraceCodec.writeVarInt(out, StackTraceEventWriterV4.this.intern(this.key));
                    StackTraceCodec.writeVarInt(out, StackTraceEventWriterV4.this.internDyn(this.tag));
                    break;
                }
                default: {
                    throw new IOException("Encoding error");
                }
            }
        }
    }

    private class TagEncoder
    implements TagDictionary.TagSetEncoder {
        DataBuffer buffer = new DataBuffer();
        TagChange pending;

        private TagEncoder() {
        }

        protected int startTag() {
            return 6;
        }

        @Override
        public int cost(String key, String tag) {
            if (tag == null || tag.length() == 0) {
                return 2 + this.keySize(key);
            }
            return 3 + this.keySize(key) + this.tagSize(tag);
        }

        private int keySize(String key) {
            return StackTraceEventWriterV4.this.stringDic.containsKey(key) ? 2 : 2 + key.length();
        }

        private int tagSize(String tag) {
            return StackTraceEventWriterV4.this.dynDic.contains(tag) ? 2 : 2 + tag.length();
        }

        @Override
        public void startTagSet(int setId, int baseId) {
            try {
                this.buffer.writeByte(this.startTag());
                StackTraceCodec.writeVarInt(this.buffer, setId);
                StackTraceCodec.writeVarInt(this.buffer, baseId);
            }
            catch (IOException e) {
                throw new CapsuleException(e);
            }
        }

        public void push(TagChange change) {
            try {
                if (this.pending != null) {
                    if ((this.pending.op == 4 && change.op == 1 || this.pending.op == 1 && change.op == 4) && this.pending.key.equals(change.key)) {
                        change.op = 3;
                        if (this.pending.tag != null) {
                            change.tag = this.pending.tag;
                        }
                        this.pending = null;
                    }
                    if (this.pending != null) {
                        this.pending.encode(this.buffer);
                    }
                    this.pending = null;
                }
                if (change.op == 4 || change.op == 1) {
                    this.pending = change;
                } else {
                    change.encode(this.buffer);
                }
            }
            catch (IOException e) {
                throw new CapsuleException(e);
            }
        }

        @Override
        public void append(String key, String tag) {
            if (tag.length() == 0) {
                this.push(new TagChange(2, key, null));
            } else {
                this.push(new TagChange(1, key, tag));
            }
        }

        @Override
        public void remove(String key) {
            this.push(new TagChange(4, key, null));
        }

        @Override
        public void remove(String key, String tag) {
            this.push(new TagChange(5, key, tag));
        }

        @Override
        public void finishTag() {
            try {
                if (this.pending != null) {
                    this.pending.encode(this.buffer);
                    this.pending = null;
                }
                this.buffer.unloadTo(StackTraceEventWriterV4.this.dos);
                StackTraceEventWriterV4.this.dos.writeByte(0);
            }
            catch (IOException e) {
                throw new CapsuleException(e);
            }
        }
    }
}

