/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.io.sstable.KeyIterator;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.IMergeIterator;
import org.apache.cassandra.utils.MergeIterator;

public class ReducingKeyIterator
implements CloseableIterator<DecoratedKey> {
    private final ArrayList<KeyIterator> iters;
    private volatile IMergeIterator<DecoratedKey, DecoratedKey> mi;

    public ReducingKeyIterator(Collection<SSTableReader> sstables) {
        this.iters = new ArrayList(sstables.size());
        for (SSTableReader sstable : sstables) {
            this.iters.add(new KeyIterator(sstable.descriptor, sstable.metadata()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeInit() {
        if (this.mi != null) {
            return;
        }
        ReducingKeyIterator reducingKeyIterator = this;
        synchronized (reducingKeyIterator) {
            if (this.mi == null) {
                this.mi = MergeIterator.get(this.iters, DecoratedKey.comparator, new MergeIterator.Reducer<DecoratedKey, DecoratedKey>(){
                    DecoratedKey reduced = null;

                    @Override
                    public boolean trivialReduceIsTrivial() {
                        return true;
                    }

                    @Override
                    public void reduce(int idx, DecoratedKey current) {
                        this.reduced = current;
                    }

                    @Override
                    protected DecoratedKey getReduced() {
                        return this.reduced;
                    }
                });
            }
        }
    }

    @Override
    public void close() {
        if (this.mi != null) {
            this.mi.close();
        }
    }

    public long getTotalBytes() {
        this.maybeInit();
        long m3 = 0L;
        for (Iterator<DecoratedKey> iter2 : this.mi.iterators()) {
            m3 += ((KeyIterator)iter2).getTotalBytes();
        }
        return m3;
    }

    public long getBytesRead() {
        this.maybeInit();
        long m3 = 0L;
        for (Iterator<DecoratedKey> iter2 : this.mi.iterators()) {
            m3 += ((KeyIterator)iter2).getBytesRead();
        }
        return m3;
    }

    @Override
    public boolean hasNext() {
        this.maybeInit();
        return this.mi.hasNext();
    }

    @Override
    public DecoratedKey next() {
        this.maybeInit();
        return (DecoratedKey)this.mi.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

