/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.common;

import com.google.common.base.Preconditions;
import o.a.c.sidecar.client.shaded.client.SidecarInstanceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SidecarInstanceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SidecarInstanceFactory.class);

    private SidecarInstanceFactory() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static SidecarInstanceImpl createFromString(String input, int defaultPort) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)input), (Object)"Unable to create sidecar instance from empty input");
        String hostname = input;
        int port = defaultPort;
        if (input.contains("]:") || !input.startsWith("[") && input.contains(":")) {
            int index = input.lastIndexOf(58);
            hostname = input.substring(0, index);
            String portStr = input.substring(index + 1);
            port = Integer.parseInt(portStr);
        }
        Preconditions.checkState((port != -1 ? 1 : 0) != 0, (String)"Unable to resolve port from %s", (Object[])new Object[]{input});
        LOGGER.info("Create sidecar instance. hostname={} port={}", (Object)hostname, (Object)port);
        return new SidecarInstanceImpl(hostname, port);
    }

    public static SidecarInstanceImpl createFromString(String hostnameWithPort) {
        return SidecarInstanceFactory.createFromString(hostnameWithPort, -1);
    }
}

