/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.utils;

import io.netty.util.concurrent.FastThreadLocal;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import org.apache.cassandra.spark.utils.ByteBufferUtils;

public final class FastThreadLocalUtf8Decoder {
    private static final FastThreadLocal<CharsetDecoder> UTF8_DECODER = new FastThreadLocal<CharsetDecoder>(){

        protected CharsetDecoder initialValue() {
            return StandardCharsets.UTF_8.newDecoder();
        }
    };

    private FastThreadLocalUtf8Decoder() {
        throw new IllegalStateException(String.valueOf(this.getClass()) + " is static utility class and shall not be instantiated");
    }

    public static String string(ByteBuffer buffer) throws CharacterCodingException {
        return ByteBufferUtils.string((ByteBuffer)buffer, () -> UTF8_DECODER.get());
    }

    public static String stringThrowRuntime(ByteBuffer buffer) {
        try {
            return FastThreadLocalUtf8Decoder.string(buffer);
        }
        catch (CharacterCodingException exception) {
            throw new RuntimeException(exception);
        }
    }
}

