/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.cassandra.spark.data.FileType;
import org.apache.cassandra.spark.utils.streaming.CassandraFile;
import org.apache.cassandra.spark.utils.streaming.CassandraFileSource;
import org.apache.cassandra.spark.utils.streaming.StreamBuffer;
import org.apache.cassandra.spark.utils.streaming.StreamConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemSource<T extends CassandraFile>
implements CassandraFileSource<T>,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemSource.class);
    static final ExecutorService FILE_IO_EXECUTOR = Executors.newFixedThreadPool(4, new ThreadFactoryBuilder().setNameFormat("file-io-%d").setDaemon(true).build());
    private final T cassandraFile;
    private final RandomAccessFile file;
    private final FileType fileType;
    private final long length;
    private final boolean autoClose;

    public FileSystemSource(T cassandraFile, FileType fileType, Path path, boolean autoClose) throws IOException {
        this.cassandraFile = cassandraFile;
        this.fileType = fileType;
        this.length = Files.size(path);
        this.autoClose = autoClose;
        this.file = new RandomAccessFile(path.toFile(), "r");
    }

    @Override
    public long maxBufferSize() {
        return this.chunkBufferSize() * 4L;
    }

    @Override
    public long chunkBufferSize() {
        return 16384L;
    }

    @Override
    public long headerChunkSize() {
        return this.chunkBufferSize();
    }

    public ExecutorService executor() {
        return FILE_IO_EXECUTOR;
    }

    @Override
    public void request(long start, long end, StreamConsumer consumer) {
        this.executor().submit(() -> {
            boolean close = this.length <= end;
            try {
                int increment = close ? 0 : 1;
                byte[] bytes = new byte[(int)(end - start + (long)increment)];
                if (this.file.getChannel().read(ByteBuffer.wrap(bytes), start) >= 0) {
                    consumer.onRead(StreamBuffer.wrap(bytes));
                    consumer.onEnd();
                } else {
                    close = true;
                }
            }
            catch (Throwable throwable) {
                close = true;
                consumer.onError(throwable);
            }
            finally {
                if (this.autoClose && close) {
                    this.closeSafe();
                }
            }
        });
    }

    @Override
    public T cassandraFile() {
        return this.cassandraFile;
    }

    @Override
    public FileType fileType() {
        return this.fileType;
    }

    @Override
    public long size() {
        return this.length;
    }

    private void closeSafe() {
        try {
            this.close();
        }
        catch (Exception exception) {
            LOGGER.warn("Exception closing InputStream", (Throwable)exception);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.file != null) {
            this.file.close();
        }
    }
}

