/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import o.a.c.sidecar.client.shaded.common.response.TokenRangeReplicasResponse;
import org.apache.cassandra.spark.bulkwriter.BroadcastableClusterInfoGroup;
import org.apache.cassandra.spark.bulkwriter.BulkSparkConf;
import org.apache.cassandra.spark.bulkwriter.CassandraClusterInfo;
import org.apache.cassandra.spark.bulkwriter.CassandraClusterInfoTest;
import org.apache.cassandra.spark.bulkwriter.RingInstance;
import org.apache.cassandra.spark.bulkwriter.TokenRangeMappingUtils;
import org.apache.cassandra.spark.bulkwriter.WriteAvailability;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.CassandraClusterInfoGroup;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.CoordinatedWriteConf;
import org.apache.cassandra.spark.bulkwriter.token.TokenRangeMapping;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.apache.cassandra.spark.exception.TimeSkewTooLargeException;
import org.apache.cassandra.spark.utils.SerializationUtils;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class CassandraClusterInfoGroupTest {
    CassandraClusterInfoGroupTest() {
    }

    @Test
    void testLookupCluster() {
        CassandraClusterInfoGroup group = this.mockClusterGroup(2, index -> this.mockClusterInfo("cluster" + index));
        Assertions.assertThat((int)group.size()).isEqualTo(2);
        group.forEach((clusterId, clusterInfo) -> ((ObjectAssert)Assertions.assertThat((Object)group.getValueOrNull(clusterId)).isSameAs(clusterInfo)).isNotNull());
        Assertions.assertThat((Object)group.getValueOrNull("cluster2")).isNull();
    }

    @Test
    void testClusterId() {
        CassandraClusterInfoGroup group = this.mockClusterGroup(2, index -> this.mockClusterInfo("cluster" + index));
        Assertions.assertThat((String)group.clusterId()).isEqualTo("ClusterInfoGroup: [cluster0, cluster1]");
        group = this.mockClusterGroup(1, index -> this.mockClusterInfo("cluster" + index));
        Assertions.assertThat((String)group.clusterId()).isEqualTo("ClusterInfoGroup: [cluster0]");
    }

    @Test
    void testDelegationOfSingleCluster() {
        CassandraClusterInfo clusterInfo = this.mockClusterInfo("cluster0");
        TokenRangeReplicasResponse response = TokenRangeMappingUtils.mockSimpleTokenRangeReplicasResponse(10, 3);
        TokenRangeMapping expectedTokenRangeMapping = TokenRangeMapping.create(() -> response, () -> Partitioner.Murmur3Partitioner, RingInstance::new);
        Mockito.when((Object)clusterInfo.getTokenRangeMapping(ArgumentMatchers.anyBoolean())).thenReturn((Object)expectedTokenRangeMapping);
        Mockito.when((Object)clusterInfo.getLowestCassandraVersion()).thenReturn((Object)"lowestCassandraVersion");
        Mockito.when((Object)clusterInfo.clusterWriteAvailability()).thenReturn(Collections.emptyMap());
        CassandraClusterInfoGroup group = this.mockClusterGroup(1, index -> clusterInfo);
        Assertions.assertThat((Map)group.clusterWriteAvailability()).isSameAs((Object)clusterInfo.clusterWriteAvailability());
        Assertions.assertThat((String)group.getLowestCassandraVersion()).isSameAs((Object)clusterInfo.getLowestCassandraVersion());
        Assertions.assertThat((Object)group.getTokenRangeMapping(true)).isSameAs((Object)clusterInfo.getTokenRangeMapping(true));
    }

    @Test
    void testAggregatePartitioner() {
        CassandraClusterInfoGroup invalidGroup = this.mockClusterGroup(2, index -> {
            CassandraClusterInfo clusterInfo = this.mockClusterInfo("cluster" + index);
            Partitioner partitioner = index % 2 == 0 ? Partitioner.Murmur3Partitioner : Partitioner.RandomPartitioner;
            Mockito.when((Object)clusterInfo.getPartitioner()).thenReturn((Object)partitioner);
            return clusterInfo;
        });
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((CassandraClusterInfoGroup)invalidGroup).getPartitioner()).isExactlyInstanceOf(IllegalStateException.class)).hasMessage("Clusters are not running with the same partitioner kind. Found partitioners: {cluster0=org.apache.cassandra.dht.Murmur3Partitioner, cluster1=org.apache.cassandra.dht.RandomPartitioner}");
        CassandraClusterInfoGroup goodGroup = this.mockClusterGroup(2, index -> {
            CassandraClusterInfo clusterInfo = this.mockClusterInfo("cluster" + index);
            Mockito.when((Object)clusterInfo.getPartitioner()).thenReturn((Object)Partitioner.Murmur3Partitioner);
            return clusterInfo;
        });
        Assertions.assertThat((Comparable)goodGroup.getPartitioner()).isEqualTo((Object)Partitioner.Murmur3Partitioner);
    }

    @Test
    void testAggregateWriteAvailability() {
        ImmutableMap cluster1Availability = ImmutableMap.of((Object)((RingInstance)Mockito.mock(RingInstance.class)), (Object)WriteAvailability.AVAILABLE);
        ImmutableMap cluster2Availability = ImmutableMap.of((Object)((RingInstance)Mockito.mock(RingInstance.class)), (Object)WriteAvailability.UNAVAILABLE_DOWN);
        CassandraClusterInfoGroup group = this.mockClusterGroup(2, arg_0 -> this.lambda$testAggregateWriteAvailability$9((Map)cluster1Availability, (Map)cluster2Availability, arg_0));
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)group.clusterWriteAvailability()).describedAs("clusterWriteAvailability retrieved from group contains entries from both clusters", new Object[0])).hasSize(2)).containsValues((Object[])new WriteAvailability[]{WriteAvailability.AVAILABLE, WriteAvailability.UNAVAILABLE_DOWN});
    }

    @Test
    void testAggregateLowestCassandraVersion() {
        CassandraClusterInfoGroup goodGroup = this.mockClusterGroup(2, index -> {
            CassandraClusterInfo clusterInfo = this.mockClusterInfo("cluster" + index);
            Mockito.when((Object)clusterInfo.getLowestCassandraVersion()).thenReturn((Object)("4.0." + index));
            return clusterInfo;
        });
        Assertions.assertThat((String)goodGroup.getLowestCassandraVersion()).isEqualTo("4.0.0");
    }

    @Test
    void testAggregateLowestCassandraVersionFailDueToDifference() {
        CassandraClusterInfoGroup badGroup = this.mockClusterGroup(2, index -> {
            CassandraClusterInfo clusterInfo = this.mockClusterInfo("cluster" + index);
            Mockito.when((Object)clusterInfo.getLowestCassandraVersion()).thenReturn((Object)(4 + index + ".0.0"));
            return clusterInfo;
        });
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((CassandraClusterInfoGroup)badGroup).getLowestCassandraVersion()).isExactlyInstanceOf(IllegalStateException.class)).hasMessage("Cluster versions are not compatible. lowest=4.0.0 and highest=5.0.0");
    }

    @Test
    void testCheckBulkWriterIsEnabledOrThrow() {
        int i = 0;
        while (i < 2) {
            int notEnabledClusterIndex = i++;
            CassandraClusterInfoGroup badGroup = this.mockClusterGroup(2, index -> {
                CassandraClusterInfo clusterInfo = this.mockClusterInfo("cluster" + index);
                if (index == notEnabledClusterIndex) {
                    ((CassandraClusterInfo)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("not enabled")}).when((Object)clusterInfo)).checkBulkWriterIsEnabledOrThrow();
                }
                return clusterInfo;
            });
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((CassandraClusterInfoGroup)badGroup).checkBulkWriterIsEnabledOrThrow()).isExactlyInstanceOf(RuntimeException.class)).hasMessage("Failed to perform action on cluster: cluster" + notEnabledClusterIndex).hasRootCauseMessage("not enabled");
        }
    }

    @Test
    void testAggregateTokenRangeMapping() {
        TokenRangeMapping<RingInstance> topology1 = TokenRangeMappingUtils.buildTokenRangeMapping(0, (ImmutableMap<String, Integer>)ImmutableMap.of((Object)"dc1", (Object)3), 5);
        TokenRangeMapping<RingInstance> topology2 = TokenRangeMappingUtils.buildTokenRangeMapping(10, (ImmutableMap<String, Integer>)ImmutableMap.of((Object)"dc1", (Object)3), 8);
        CassandraClusterInfoGroup group = this.mockClusterGroup(2, index -> {
            TokenRangeMapping topology = index == 0 ? topology1 : topology2;
            CassandraClusterInfo clusterInfo = this.mockClusterInfo("cluster" + index);
            Mockito.when((Object)clusterInfo.getTokenRangeMapping(ArgumentMatchers.anyBoolean())).thenReturn((Object)topology);
            return clusterInfo;
        });
        TokenRangeMapping topology = group.getTokenRangeMapping(false);
        TokenRangeMapping expected = TokenRangeMapping.consolidate(Arrays.asList(topology1, topology2));
        Assertions.assertThat((Object)topology).isEqualTo((Object)expected);
        TokenRangeMapping cachedTopology = group.getTokenRangeMapping(true);
        Assertions.assertThat((Object)cachedTopology).isSameAs((Object)topology);
    }

    @Test
    void testTimeSkewTooLarge() {
        int i = 0;
        while (i < 2) {
            int clusterIndexWithLargeTimeSkew = i++;
            Instant remoteNow = Instant.ofEpochMilli(1726604289530L);
            CassandraClusterInfoGroup group = this.mockClusterGroup(2, index -> {
                if (index == clusterIndexWithLargeTimeSkew) {
                    CassandraClusterInfo ci = (CassandraClusterInfo)Mockito.spy((Object)CassandraClusterInfoTest.mockClusterInfoForTimeSkewTest(10, remoteNow));
                    Mockito.when((Object)ci.clusterId()).thenReturn((Object)("cluster" + index));
                    return ci;
                }
                return this.mockClusterInfo("cluster" + index);
            });
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> group.validateTimeSkew(Range.openClosed((Comparable)BigInteger.valueOf(10L), (Comparable)BigInteger.valueOf(20L)))).isExactlyInstanceOf(TimeSkewTooLargeException.class)).hasMessageContaining("Time skew between Spark and Cassandra is too large. ").hasMessageContaining("allowableSkewInMinutes=10, ").hasMessageContaining("remoteCassandraTime=2024-09-17T20:18:09.530Z, ").hasMessageContaining("clusterId=cluster" + clusterIndexWithLargeTimeSkew);
        }
    }

    @Test
    void testCreateClusterInfoListFailsDueToAbsentConfiguration() {
        BulkSparkConf conf = (BulkSparkConf)Mockito.mock(BulkSparkConf.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CassandraClusterInfoGroup.fromBulkSparkConf((BulkSparkConf)conf)).isInstanceOf(IllegalArgumentException.class)).hasMessage("In order to create an instance of CassandraCoordinatedBulkWriterContext, you must provide the appropriate coordinated write configuration by setting the `COORDINATED_WRITE_CONFIG` writer option.");
    }

    @Test
    void testCreateClusterInfoListFailsDueToEmptyConfiguration() {
        BulkSparkConf conf = (BulkSparkConf)Mockito.mock(BulkSparkConf.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)conf.coordinatedWriteConf().clusters()).thenReturn(Collections.emptyMap());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CassandraClusterInfoGroup.fromBulkSparkConf((BulkSparkConf)conf)).isInstanceOf(IllegalStateException.class)).hasMessageContaining("No cluster info is built from");
    }

    @Test
    void testCreateClusterInfoListFailsDueToEmptyClusterId() {
        BulkSparkConf conf = (BulkSparkConf)Mockito.mock(BulkSparkConf.class);
        CoordinatedWriteConf.SimpleClusterConf clusterConf = new CoordinatedWriteConf.SimpleClusterConf(Collections.singletonList("localhost:9043"), "localDc");
        Mockito.when((Object)conf.coordinatedWriteConf()).thenReturn((Object)new CoordinatedWriteConf(Collections.singletonMap("", clusterConf)));
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CassandraClusterInfoGroup.fromBulkSparkConf((BulkSparkConf)conf)).isInstanceOf(IllegalStateException.class)).describedAs("The exception message should include the original json to help spot the wrong configuration (empty clusterId)", new Object[0])).hasMessage("Found coordinatedWriteConf with empty or null clusterId. CoordinatedWriteConf{json={\"\":{\"sidecarContactPoints\":[\"localhost:9043\"],\"localDc\":\"localDc\",\"writeToLocalDcOnly\":false}}}");
    }

    @Test
    void testSerDeser() {
        CassandraClusterInfoGroup originalGroup = this.mockClusterGroup(2, index -> {
            CassandraClusterInfo clusterInfo = this.mockClusterInfo("cluster" + index);
            Mockito.when((Object)clusterInfo.getPartitioner()).thenReturn((Object)Partitioner.Murmur3Partitioner);
            Mockito.when((Object)clusterInfo.getLowestCassandraVersion()).thenReturn((Object)"4.0.0");
            return clusterInfo;
        });
        BulkSparkConf conf = (BulkSparkConf)Mockito.mock(BulkSparkConf.class, (MockSettings)Mockito.withSettings().serializable());
        BroadcastableClusterInfoGroup broadcastable = BroadcastableClusterInfoGroup.from((CassandraClusterInfoGroup)originalGroup, (BulkSparkConf)conf);
        byte[] serializedBytes = SerializationUtils.serialize(broadcastable);
        BroadcastableClusterInfoGroup deserializedBroadcastable = SerializationUtils.deserialize(serializedBytes, BroadcastableClusterInfoGroup.class);
        ((AbstractStringAssert)Assertions.assertThat((String)deserializedBroadcastable.clusterId()).describedAs("ClusterId should be preserved after serialization", new Object[0])).isEqualTo(originalGroup.clusterId());
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)deserializedBroadcastable.getPartitioner()).describedAs("Partitioner should be preserved after serialization", new Object[0])).isEqualTo((Object)Partitioner.Murmur3Partitioner);
        ((AbstractStringAssert)Assertions.assertThat((String)deserializedBroadcastable.getLowestCassandraVersion()).describedAs("Lowest Cassandra version should be preserved after serialization", new Object[0])).isEqualTo("4.0.0");
        ((AbstractIntegerAssert)Assertions.assertThat((int)deserializedBroadcastable.size()).describedAs("Number of clusters should be preserved after serialization", new Object[0])).isEqualTo(2);
        int[] clusterCount = new int[]{0};
        deserializedBroadcastable.forEach((clusterId, clusterInfo) -> {
            Assertions.assertThat((String)clusterId).isIn(new Object[]{"cluster0", "cluster1"});
            Assertions.assertThat((Object)clusterInfo).isNotNull();
            clusterCount[0] = clusterCount[0] + 1;
        });
        Assertions.assertThat((int)clusterCount[0]).isEqualTo(2);
    }

    private CassandraClusterInfoGroup mockClusterGroup(int size, Function<Integer, CassandraClusterInfo> clusterInfoCreator) {
        List clusterInfos = IntStream.range(0, size).boxed().map(clusterInfoCreator).collect(Collectors.toList());
        return CassandraClusterInfoGroup.createFrom(clusterInfos);
    }

    private CassandraClusterInfo mockClusterInfo(String clusterId) {
        CassandraClusterInfo clusterInfo = (CassandraClusterInfo)Mockito.mock(CassandraClusterInfo.class);
        Mockito.when((Object)clusterInfo.clusterId()).thenReturn((Object)clusterId);
        return clusterInfo;
    }

    private /* synthetic */ CassandraClusterInfo lambda$testAggregateWriteAvailability$9(Map cluster1Availability, Map cluster2Availability, Integer index) {
        Map availability = index % 2 == 0 ? cluster1Availability : cluster2Availability;
        CassandraClusterInfo clusterInfo = this.mockClusterInfo("cluster" + index);
        Mockito.when((Object)clusterInfo.clusterWriteAvailability()).thenReturn((Object)availability);
        return clusterInfo;
    }
}

