/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.IOException;
import org.apache.cassandra.io.util.DataOutputStreamPlus;
import org.apache.cassandra.utils.BloomCalculations;
import org.apache.cassandra.utils.BloomFilter;
import org.apache.cassandra.utils.IFilter;
import org.apache.cassandra.utils.concurrent.Ref;
import org.apache.cassandra.utils.obs.OffHeapBitSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterFactory {
    public static final IFilter AlwaysPresent = AlwaysPresentFilter.instance;
    private static final Logger logger = LoggerFactory.getLogger(FilterFactory.class);
    private static final long BITSET_EXCESS = 20L;

    public static IFilter getFilter(long numElements, int targetBucketsPerElem) {
        int maxBucketsPerElement = Math.max(1, BloomCalculations.maxBucketsPerElement(numElements));
        int bucketsPerElement = Math.min(targetBucketsPerElem, maxBucketsPerElement);
        if (bucketsPerElement < targetBucketsPerElem) {
            logger.warn("Cannot provide an optimal BloomFilter for {} elements ({}/{} buckets per element).", new Object[]{numElements, bucketsPerElement, targetBucketsPerElem});
        }
        BloomCalculations.BloomSpecification spec = BloomCalculations.computeBloomSpec(bucketsPerElement);
        return FilterFactory.createFilter(spec.K, numElements, spec.bucketsPerElement);
    }

    public static IFilter getFilter(long numElements, double maxFalsePosProbability) {
        assert (maxFalsePosProbability <= 1.0) : "Invalid probability";
        if (maxFalsePosProbability == 1.0) {
            return AlwaysPresent;
        }
        int bucketsPerElement = BloomCalculations.maxBucketsPerElement(numElements);
        BloomCalculations.BloomSpecification spec = BloomCalculations.computeBloomSpec(bucketsPerElement, maxFalsePosProbability);
        return FilterFactory.createFilter(spec.K, numElements, spec.bucketsPerElement);
    }

    private static IFilter createFilter(int hash, long numElements, int bucketsPer) {
        long numBits = numElements * (long)bucketsPer + 20L;
        OffHeapBitSet bitset = new OffHeapBitSet(numBits);
        return new BloomFilter(hash, bitset);
    }

    private static class AlwaysPresentFilter
    implements IFilter {
        public static final AlwaysPresentFilter instance = new AlwaysPresentFilter();

        private AlwaysPresentFilter() {
        }

        @Override
        public boolean isPresent(IFilter.FilterKey key) {
            return true;
        }

        @Override
        public void add(IFilter.FilterKey key) {
        }

        @Override
        public void clear() {
        }

        @Override
        public void close() {
        }

        @Override
        public IFilter sharedCopy() {
            return this;
        }

        @Override
        public Throwable close(Throwable accumulate) {
            return accumulate;
        }

        @Override
        public void addTo(Ref.IdentityCollection identities) {
        }

        @Override
        public long serializedSize(boolean oldSerializationFormat) {
            return 0L;
        }

        @Override
        public void serialize(DataOutputStreamPlus out, boolean oldSerializationFormat) throws IOException {
        }

        @Override
        public long offHeapSize() {
            return 0L;
        }

        @Override
        public boolean isInformative() {
            return false;
        }
    }
}

