/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht.tokenallocator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.PriorityQueue;
import java.util.Queue;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.dht.tokenallocator.ReplicationStrategy;
import org.apache.cassandra.dht.tokenallocator.TokenAllocatorBase;
import org.apache.cassandra.dht.tokenallocator.TokenAllocatorDiagnostics;

public class NoReplicationTokenAllocator<Unit>
extends TokenAllocatorBase<Unit> {
    PriorityQueue<TokenAllocatorBase.Weighted<TokenAllocatorBase.UnitInfo>> sortedUnits = Queues.newPriorityQueue();
    Map<Unit, PriorityQueue<TokenAllocatorBase.Weighted<TokenAllocatorBase.TokenInfo>>> tokensInUnits = Maps.newHashMap();
    private static final double MAX_TAKEOVER_RATIO = 0.9;
    private static final double MIN_TAKEOVER_RATIO = 0.09999999999999998;

    public NoReplicationTokenAllocator(NavigableMap<Token, Unit> sortedTokens, ReplicationStrategy<Unit> strategy, IPartitioner partitioner) {
        super(sortedTokens, strategy, partitioner);
    }

    private TokenAllocatorBase.TokenInfo<Unit> createTokenInfos(Map<Unit, TokenAllocatorBase.UnitInfo<Unit>> units) {
        if (units.isEmpty()) {
            return null;
        }
        TokenAllocatorBase.TokenInfo<Unit> prev = null;
        TokenAllocatorBase.TokenInfo first = null;
        for (Map.Entry en : this.sortedTokens.entrySet()) {
            Token t2 = (Token)en.getKey();
            TokenAllocatorBase.UnitInfo<Unit> ni = units.get(en.getValue());
            TokenAllocatorBase.TokenInfo<Unit> ti = new TokenAllocatorBase.TokenInfo<Unit>(t2, ni);
            first = ti.insertAfter(first, prev);
            prev = ti;
        }
        TokenAllocatorBase.TokenInfo curr = first;
        this.tokensInUnits.clear();
        this.sortedUnits.clear();
        do {
            this.populateTokenInfoAndAdjustUnit(curr);
        } while ((curr = (TokenAllocatorBase.TokenInfo)curr.next) != first);
        for (TokenAllocatorBase.UnitInfo<Unit> unitInfo : units.values()) {
            this.sortedUnits.add(new TokenAllocatorBase.Weighted<TokenAllocatorBase.UnitInfo<Unit>>(unitInfo.ownership, unitInfo));
        }
        TokenAllocatorDiagnostics.tokenInfosCreated(this, this.sortedUnits, this.sortedTokens, first);
        return first;
    }

    protected void createTokenInfos() {
        this.createTokenInfos(this.createUnitInfos(Maps.newHashMap()));
    }

    private void populateTokenInfoAndAdjustUnit(TokenAllocatorBase.TokenInfo<Unit> token) {
        token.replicationStart = token.prevInRing().token;
        token.replicationThreshold = token.token;
        token.replicatedOwnership = token.replicationStart.size(token.token);
        token.owningUnit.ownership += token.replicatedOwnership;
        PriorityQueue<TokenAllocatorBase.Weighted<TokenAllocatorBase.TokenInfo<Object>>> unitTokens = this.tokensInUnits.get(token.owningUnit.unit);
        if (unitTokens == null) {
            unitTokens = Queues.newPriorityQueue();
            this.tokensInUnits.put(token.owningUnit.unit, unitTokens);
        }
        unitTokens.add(new TokenAllocatorBase.Weighted<TokenAllocatorBase.TokenInfo<Unit>>(token.replicatedOwnership, token));
    }

    @Override
    public Collection<Token> addUnit(Unit newUnit, int numTokens) {
        double average;
        TokenAllocatorBase.Weighted<TokenAllocatorBase.UnitInfo> unit;
        assert (!this.tokensInUnits.containsKey(newUnit));
        HashMap<Object, TokenAllocatorBase.GroupInfo> groups = Maps.newHashMap();
        TokenAllocatorBase.UnitInfo<Unit> newUnitInfo = new TokenAllocatorBase.UnitInfo<Unit>(newUnit, 0.0, groups, this.strategy);
        Map unitInfos = this.createUnitInfos(groups);
        if (unitInfos.isEmpty()) {
            return this.generateSplits(newUnit, numTokens);
        }
        if (numTokens > this.sortedTokens.size()) {
            return this.generateSplits(newUnit, numTokens);
        }
        TokenAllocatorBase.TokenInfo head = this.createTokenInfos(unitInfos);
        double targetAverage = 0.0;
        double sum = 0.0;
        ArrayList<TokenAllocatorBase.Weighted<TokenAllocatorBase.UnitInfo>> unitsToChange = new ArrayList<TokenAllocatorBase.Weighted<TokenAllocatorBase.UnitInfo>>();
        for (int i = 0; i < numTokens && (unit = this.sortedUnits.peek()) != null && !(unit.weight <= (average = (sum += unit.weight) / (double)(unitsToChange.size() + 2))); ++i) {
            this.sortedUnits.remove();
            unitsToChange.add(unit);
            targetAverage = average;
        }
        ArrayList<Token> newTokens = Lists.newArrayListWithCapacity(numTokens);
        double sizeCorrection = Math.min(1.0, ((double)numTokens + 1.0) / ((double)unitInfos.size() + 1.0));
        double spread = targetAverage * sizeCorrection * 2.0 / (double)(2 * numTokens + 1);
        double target = targetAverage + spread / 2.0;
        double step = spread / (double)unitsToChange.size();
        int nr = 0;
        for (TokenAllocatorBase.Weighted weighted : unitsToChange) {
            int tokensToChange = numTokens / unitsToChange.size() + (nr < numTokens % unitsToChange.size() ? 1 : 0);
            Queue unitTokens = this.tokensInUnits.get(((TokenAllocatorBase.UnitInfo)weighted.value).unit);
            ArrayList<TokenAllocatorBase.Weighted> tokens = Lists.newArrayListWithCapacity(tokensToChange);
            double workWeight = 0.0;
            for (int i = 0; i < tokensToChange; ++i) {
                TokenAllocatorBase.Weighted wt = (TokenAllocatorBase.Weighted)unitTokens.remove();
                tokens.add(wt);
                workWeight += wt.weight;
                ((TokenAllocatorBase.UnitInfo)weighted.value).ownership -= wt.weight;
            }
            double toTakeOver = weighted.weight - target;
            for (TokenAllocatorBase.Weighted wt : tokens) {
                double slice;
                if (toTakeOver < workWeight) {
                    slice = toTakeOver / workWeight;
                    if (slice < 0.09999999999999998) {
                        slice = 0.09999999999999998;
                    }
                    if (slice > 0.9) {
                        slice = 0.9;
                    }
                } else {
                    slice = 0.9;
                }
                Token token = this.partitioner.split(((TokenAllocatorBase.TokenInfo)wt.value).prevInRing().token, ((TokenAllocatorBase.TokenInfo)wt.value).token, slice);
                this.sortedTokens.put(token, newUnit);
                TokenAllocatorBase.TokenInfo<Unit> ti = new TokenAllocatorBase.TokenInfo<Unit>(token, newUnitInfo);
                ti.insertAfter(head, ((TokenAllocatorBase.TokenInfo)wt.value).prevInRing());
                this.populateTokenInfoAndAdjustUnit(ti);
                this.populateTokenInfoAndAdjustUnit((TokenAllocatorBase.TokenInfo)wt.value);
                newTokens.add(token);
            }
            this.sortedUnits.add(new TokenAllocatorBase.Weighted<TokenAllocatorBase.UnitInfo>(((TokenAllocatorBase.UnitInfo)weighted.value).ownership, (TokenAllocatorBase.UnitInfo)weighted.value));
            target -= step;
            ++nr;
        }
        this.sortedUnits.add(new TokenAllocatorBase.Weighted<TokenAllocatorBase.UnitInfo<Unit>>(newUnitInfo.ownership, newUnitInfo));
        TokenAllocatorDiagnostics.unitedAdded(this, numTokens, this.sortedUnits, this.sortedTokens, newTokens, newUnit);
        return newTokens;
    }

    @Override
    Collection<Token> generateSplits(Unit newUnit, int numTokens) {
        Collection<Token> tokens = super.generateSplits(newUnit, numTokens);
        TokenAllocatorDiagnostics.splitsGenerated(this, numTokens, this.sortedUnits, this.sortedTokens, newUnit, tokens);
        return tokens;
    }

    void removeUnit(Unit n) {
        Iterator<TokenAllocatorBase.Weighted<TokenAllocatorBase.UnitInfo>> it = this.sortedUnits.iterator();
        while (it.hasNext()) {
            if (!((TokenAllocatorBase.UnitInfo)it.next().value).unit.equals(n)) continue;
            it.remove();
            break;
        }
        PriorityQueue<TokenAllocatorBase.Weighted<TokenAllocatorBase.TokenInfo>> tokenInfos = this.tokensInUnits.remove(n);
        ArrayList<Token> tokens = Lists.newArrayListWithCapacity(tokenInfos.size());
        for (TokenAllocatorBase.Weighted<TokenAllocatorBase.TokenInfo> tokenInfo : tokenInfos) {
            tokens.add(((TokenAllocatorBase.TokenInfo)tokenInfo.value).token);
        }
        this.sortedTokens.keySet().removeAll(tokens);
        TokenAllocatorDiagnostics.unitRemoved(this, n, this.sortedUnits, this.sortedTokens);
    }

    @Override
    public int getReplicas() {
        return 1;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

