/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Objects;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.cache.IMeasurableMemory;
import org.apache.cassandra.db.Digest;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.CassandraUInt;
import org.apache.cassandra.utils.ObjectSizes;

public class DeletionTime
implements Comparable<DeletionTime>,
IMeasurableMemory {
    public static final long EMPTY_SIZE = ObjectSizes.measure(new DeletionTime(0L, 0));
    public static final DeletionTime LIVE = new DeletionTime(Long.MIN_VALUE, Long.MAX_VALUE);
    private static final Serializer serializer = new Serializer();
    private static final Serializer legacySerializer = new LegacySerializer();
    private final long markedForDeleteAt;
    final int localDeletionTimeUnsignedInteger;

    public static DeletionTime build(long markedForDeleteAt, long localDeletionTime) {
        return localDeletionTime < 0L || localDeletionTime > Cell.MAX_DELETION_TIME ? new InvalidDeletionTime(markedForDeleteAt) : new DeletionTime(markedForDeleteAt, localDeletionTime);
    }

    static DeletionTime buildUnsafeWithUnsignedInteger(long markedForDeleteAt, int localDeletionTimeUnsignedInteger) {
        return CassandraUInt.compare(Cell.MAX_DELETION_TIME_UNSIGNED_INTEGER, localDeletionTimeUnsignedInteger) < 0 ? new InvalidDeletionTime(markedForDeleteAt) : new DeletionTime(markedForDeleteAt, localDeletionTimeUnsignedInteger);
    }

    private DeletionTime(long markedForDeleteAt, long localDeletionTime) {
        this(markedForDeleteAt, Cell.deletionTimeLongToUnsignedInteger(localDeletionTime));
    }

    private DeletionTime(long markedForDeleteAt, int localDeletionTimeUnsignedInteger) {
        this.markedForDeleteAt = markedForDeleteAt;
        this.localDeletionTimeUnsignedInteger = localDeletionTimeUnsignedInteger;
    }

    public long markedForDeleteAt() {
        return this.markedForDeleteAt;
    }

    public long localDeletionTime() {
        return Cell.deletionTimeUnsignedIntegerToLong(this.localDeletionTimeUnsignedInteger);
    }

    public boolean isLive() {
        return this.markedForDeleteAt() == Long.MIN_VALUE && this.localDeletionTime() == Long.MAX_VALUE;
    }

    public void digest(Digest digest) {
        digest.updateWithLong(this.markedForDeleteAt());
    }

    public boolean validate() {
        return true;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DeletionTime)) {
            return false;
        }
        DeletionTime that = (DeletionTime)o;
        return this.markedForDeleteAt() == that.markedForDeleteAt() && this.localDeletionTime() == that.localDeletionTime();
    }

    public final int hashCode() {
        return Objects.hashCode(this.markedForDeleteAt(), this.localDeletionTime());
    }

    public String toString() {
        return String.format("deletedAt=%d, localDeletion=%d", this.markedForDeleteAt(), this.localDeletionTime());
    }

    @Override
    public int compareTo(DeletionTime dt) {
        if (this.markedForDeleteAt() < dt.markedForDeleteAt()) {
            return -1;
        }
        if (this.markedForDeleteAt() > dt.markedForDeleteAt()) {
            return 1;
        }
        return CassandraUInt.compare(this.localDeletionTimeUnsignedInteger, dt.localDeletionTimeUnsignedInteger);
    }

    public boolean supersedes(DeletionTime dt) {
        return this.markedForDeleteAt() > dt.markedForDeleteAt() || this.markedForDeleteAt() == dt.markedForDeleteAt() && this.localDeletionTime() > dt.localDeletionTime();
    }

    public boolean deletes(LivenessInfo info) {
        return this.deletes(info.timestamp());
    }

    public boolean deletes(Cell<?> cell) {
        return this.deletes(cell.timestamp());
    }

    public boolean deletes(long timestamp) {
        return timestamp <= this.markedForDeleteAt();
    }

    public int dataSize() {
        return 12;
    }

    @Override
    public long unsharedHeapSize() {
        if (this == LIVE) {
            return 0L;
        }
        return EMPTY_SIZE;
    }

    public static Serializer getSerializer(Version version) {
        if (version.hasUIntDeletionTime()) {
            return serializer;
        }
        return legacySerializer;
    }

    public static class InvalidDeletionTime
    extends DeletionTime {
        private InvalidDeletionTime(long markedForDeleteAt) {
            super(markedForDeleteAt, Cell.INVALID_DELETION_TIME);
        }

        @Override
        public long localDeletionTime() {
            return Cell.INVALID_DELETION_TIME;
        }

        @Override
        public boolean validate() {
            return false;
        }
    }

    public static class LegacySerializer
    extends Serializer {
        @Override
        public void serialize(DeletionTime delTime, DataOutputPlus out) throws IOException {
            int ldt = delTime.localDeletionTime() == Long.MAX_VALUE ? Integer.MAX_VALUE : (int)Math.min(delTime.localDeletionTime(), 0x7FFFFFFEL);
            out.writeInt(ldt);
            out.writeLong(delTime.markedForDeleteAt);
        }

        @Override
        public DeletionTime deserialize(DataInputPlus in) throws IOException {
            int ldt = in.readInt();
            long mfda = in.readLong();
            return mfda == Long.MIN_VALUE && ldt == Integer.MAX_VALUE ? LIVE : DeletionTime.build(mfda, ldt);
        }

        @Override
        public DeletionTime deserialize(ByteBuffer buf, int offset) {
            int ldt = buf.getInt(offset);
            long mfda = buf.getLong(offset + 4);
            return mfda == Long.MIN_VALUE && ldt == Integer.MAX_VALUE ? LIVE : new DeletionTime(mfda, ldt);
        }

        @Override
        public void skip(DataInputPlus in) throws IOException {
            in.skipBytesFully(12);
        }

        @Override
        public long serializedSize(DeletionTime delTime) {
            return TypeSizes.sizeof(Integer.MAX_VALUE) + TypeSizes.sizeof(delTime.markedForDeleteAt());
        }
    }

    public static class Serializer
    implements ISerializer<DeletionTime> {
        private static final int IS_LIVE_DELETION = 128;

        @Override
        public void serialize(DeletionTime delTime, DataOutputPlus out) throws IOException {
            if (delTime == LIVE) {
                out.writeByte(128);
            } else {
                out.writeLong(delTime.markedForDeleteAt());
                out.writeInt(delTime.localDeletionTimeUnsignedInteger);
            }
        }

        @Override
        public DeletionTime deserialize(DataInputPlus in) throws IOException {
            byte flags = in.readByte();
            if ((flags & 0x80) != 0) {
                if ((flags & 0xFF) != 128) {
                    throw new IOException("Corrupted sstable. Invalid flags found deserializing DeletionTime: " + Integer.toBinaryString(flags & 0xFF));
                }
                return LIVE;
            }
            byte bytes1 = in.readByte();
            short bytes2 = in.readShort();
            int bytes4 = in.readInt();
            long mfda = this.readBytesToMFDA(flags, bytes1, bytes2, bytes4);
            int localDeletionTimeUnsignedInteger = in.readInt();
            return new DeletionTime(mfda, localDeletionTimeUnsignedInteger);
        }

        public DeletionTime deserialize(ByteBuffer buf, int offset) throws IOException {
            byte flags = buf.get(offset);
            if ((flags & 0x80) != 0) {
                if ((flags & 0xFF) != 128) {
                    throw new IOException("Corrupted sstable. Invalid flags found deserializing DeletionTime: " + Integer.toBinaryString(flags & 0xFF));
                }
                return LIVE;
            }
            long mfda = buf.getLong(offset);
            int localDeletionTimeUnsignedInteger = buf.getInt(offset + 8);
            return new DeletionTime(mfda, localDeletionTimeUnsignedInteger);
        }

        @Override
        public void skip(DataInputPlus in) throws IOException {
            byte flags = in.readByte();
            if ((flags & 0x80) != 0) {
                if ((flags & 0xFF) != 128) {
                    throw new IOException("Corrupted sstable. Invalid flags found deserializing DeletionTime: " + Integer.toBinaryString(flags & 0xFF));
                }
                return;
            }
            in.skipBytesFully(11);
        }

        @Override
        public long serializedSize(DeletionTime delTime) {
            if (delTime == LIVE) {
                return 1L;
            }
            return 12L;
        }

        private long readBytesToMFDA(int flagsByte, int bytes1, int bytes2, int bytes4) {
            long mfda = (long)flagsByte & 0xFFL;
            mfda = (mfda << 8) + ((long)bytes1 & 0xFFL);
            mfda = (mfda << 16) + ((long)bytes2 & 0xFFFFL);
            mfda = (mfda << 32) + ((long)bytes4 & 0xFFFFFFFFL);
            return mfda;
        }
    }
}

