/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.cassandra.cache.CacheKey;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.filter.ClusteringIndexNamesFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.utils.ByteArrayUtil;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.ObjectSizes;

public final class CounterCacheKey
extends CacheKey {
    private static final long EMPTY_SIZE = ObjectSizes.measure(new CounterCacheKey(TableMetadata.builder("ks", "tab").addPartitionKeyColumn("pk", UTF8Type.instance).build(), ByteBufferUtil.EMPTY_BYTE_BUFFER, ByteBuffer.allocate(1)));
    private final byte[] partitionKey;
    private final byte[] cellName;

    private CounterCacheKey(TableMetadata tableMetadata, byte[] partitionKey, byte[] cellName) {
        super(tableMetadata);
        this.partitionKey = partitionKey;
        this.cellName = cellName;
    }

    private CounterCacheKey(TableMetadata tableMetadata, ByteBuffer partitionKey, ByteBuffer cellName) {
        this(tableMetadata, ByteBufferUtil.getArray(partitionKey), ByteBufferUtil.getArray(cellName));
    }

    public static CounterCacheKey create(TableMetadata tableMetadata, ByteBuffer partitionKey, Clustering<?> clustering, ColumnMetadata c, CellPath path) {
        return new CounterCacheKey(tableMetadata, partitionKey, CounterCacheKey.makeCellName(clustering, c, path));
    }

    private static ByteBuffer makeCellName(Clustering<?> clustering, ColumnMetadata c, CellPath path) {
        int i;
        int cs = clustering.size();
        ByteBuffer[] values = new ByteBuffer[cs + 1 + (path == null ? 0 : path.size())];
        for (i = 0; i < cs; ++i) {
            values[i] = clustering.bufferAt(i);
        }
        values[cs] = c.name.bytes;
        if (path != null) {
            for (i = 0; i < path.size(); ++i) {
                values[cs + 1 + i] = path.get(i);
            }
        }
        return CompositeType.build(ByteBufferAccessor.instance, values);
    }

    public ByteBuffer partitionKey() {
        return ByteBuffer.wrap(this.partitionKey);
    }

    public ByteBuffer readCounterValue(ColumnFamilyStore cfs) {
        TableMetadata metadata = cfs.metadata();
        assert (metadata.id.equals(this.tableId) && Objects.equals(metadata.indexName().orElse(null), this.indexName));
        DecoratedKey key = cfs.decorateKey(this.partitionKey());
        int clusteringSize = metadata.comparator.size();
        List<ByteBuffer> buffers = CompositeType.splitName(ByteBuffer.wrap(this.cellName), ByteBufferAccessor.instance);
        assert (buffers.size() >= clusteringSize + 1);
        Clustering<ByteBuffer> clustering = Clustering.make(buffers.subList(0, clusteringSize).toArray(new ByteBuffer[clusteringSize]));
        ColumnMetadata column = metadata.getColumn(buffers.get(clusteringSize));
        if (column == null) {
            return null;
        }
        CellPath path = column.isComplex() ? CellPath.create(buffers.get(buffers.size() - 1)) : null;
        long nowInSec = FBUtilities.nowInSeconds();
        ColumnFilter.Builder builder = ColumnFilter.selectionBuilder();
        if (path == null) {
            builder.add(column);
        } else {
            builder.select(column, path);
        }
        ClusteringIndexNamesFilter filter = new ClusteringIndexNamesFilter(FBUtilities.singleton(clustering, metadata.comparator), false);
        SinglePartitionReadCommand cmd = SinglePartitionReadCommand.create(metadata, nowInSec, key, builder.build(), filter);
        try (ReadExecutionController controller = cmd.executionController();){
            ByteBuffer byteBuffer;
            block20: {
                RowIterator iter2 = UnfilteredRowIterators.filter(cmd.queryMemtableAndDisk(cfs, controller), nowInSec);
                try {
                    ByteBuffer value = null;
                    if (column.isStatic()) {
                        value = iter2.staticRow().getCell(column).buffer();
                    } else if (iter2.hasNext()) {
                        value = ((Row)iter2.next()).getCell(column).buffer();
                    }
                    byteBuffer = value;
                    if (iter2 == null) break block20;
                }
                catch (Throwable throwable) {
                    if (iter2 != null) {
                        try {
                            iter2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                iter2.close();
            }
            return byteBuffer;
        }
    }

    public void write(DataOutputPlus out) throws IOException {
        ByteArrayUtil.writeWithLength(this.partitionKey, out);
        ByteArrayUtil.writeWithLength(this.cellName, out);
    }

    public static CounterCacheKey read(TableMetadata tableMetadata, DataInputPlus in) throws IOException {
        return new CounterCacheKey(tableMetadata, ByteBufferUtil.readBytesWithLength(in), ByteBufferUtil.readBytesWithLength(in));
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE + ObjectSizes.sizeOfArray(this.partitionKey) + ObjectSizes.sizeOfArray(this.cellName);
    }

    public String toString() {
        TableMetadataRef tableRef = Schema.instance.getTableMetadataRef(this.tableId);
        return String.format("CounterCacheKey(%s, %s, %s, %s)", tableRef, this.indexName, ByteBufferUtil.bytesToHex(ByteBuffer.wrap(this.partitionKey)), ByteBufferUtil.bytesToHex(ByteBuffer.wrap(this.cellName)));
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.tableId, this.indexName, this.partitionKey, this.cellName});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CounterCacheKey)) {
            return false;
        }
        CounterCacheKey cck = (CounterCacheKey)o;
        return this.tableId.equals(cck.tableId) && Objects.equals(this.indexName, cck.indexName) && Arrays.equals(this.partitionKey, cck.partitionKey) && Arrays.equals(this.cellName, cck.cellName);
    }
}

