/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.Writer;
import java.math.BigDecimal;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.StreamingDataOutput;
import net.openhft.chronicle.bytes.internal.ByteStringWriter;
import net.openhft.chronicle.bytes.internal.BytesInternal;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.io.UnsafeText;
import org.jetbrains.annotations.NotNull;

public interface ByteStringAppender<B extends ByteStringAppender<B>>
extends StreamingDataOutput<B>,
Appendable {
    @NotNull
    default public Writer writer() {
        return new ByteStringWriter(this);
    }

    @NotNull
    default public B append(char ch) throws IllegalStateException {
        try {
            BytesInternal.appendUtf8Char(this, ch);
            return (B)this;
        }
        catch (BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    default public B append(@NotNull CharSequence cs) {
        if (cs.length() == 0) {
            return (B)this;
        }
        return (B)this.append(cs, 0, cs.length());
    }

    @NotNull
    default public B append(boolean flag) throws BufferOverflowException, IllegalStateException {
        return (B)this.append(flag ? (char)'T' : 'F');
    }

    @NotNull
    default public B append(int value) throws BufferOverflowException, IllegalArgumentException, IllegalStateException {
        BytesInternal.appendBase10(this, value);
        return (B)this;
    }

    @NotNull
    default public B append(long value) throws BufferOverflowException, IllegalStateException {
        if (value == (long)((int)value)) {
            BytesInternal.appendBase10(this, (int)value);
        } else {
            BytesInternal.appendBase10(this, value);
        }
        return (B)this;
    }

    @NotNull
    default public B appendBase(long value, int base) throws BufferOverflowException, IllegalArgumentException, IllegalStateException, IndexOutOfBoundsException {
        BytesInternal.append(this, value, base);
        return (B)this;
    }

    @NotNull
    default public B appendBase16(long value) throws BufferOverflowException, IllegalArgumentException, IllegalStateException {
        BytesInternal.appendBase16(this, value, 1);
        return (B)this;
    }

    @NotNull
    default public B appendBase16(long value, int minDigits) throws BufferOverflowException, IllegalArgumentException, IllegalStateException {
        BytesInternal.appendBase16(this, value, minDigits);
        return (B)this;
    }

    @NotNull
    default public B appendDecimal(long value, int decimalPlaces) throws BufferOverflowException, IllegalStateException, ArithmeticException, IllegalArgumentException {
        BytesInternal.appendDecimal(this, value, decimalPlaces);
        return (B)this;
    }

    @NotNull
    default public B append(float f) throws BufferOverflowException, IllegalStateException {
        float f2 = Math.abs(f);
        if ((double)f2 > 1000000.0 || (double)f2 < 0.001) {
            return (B)this.append(Float.toString(f));
        }
        int precision = (int)Math.floor(6.0 - Math.log10(f2));
        long tens = Maths.tens(precision);
        return this.append((double)Math.round(f * (float)tens) / (double)tens);
    }

    @NotNull
    default public B append(double d) throws BufferOverflowException, IllegalStateException {
        BytesInternal.append(this, d);
        return (B)this;
    }

    @NotNull
    default public B append(double d, int decimalPlaces) throws BufferOverflowException, IllegalArgumentException, IllegalStateException, ArithmeticException {
        if (decimalPlaces < 0) {
            throw new IllegalArgumentException();
        }
        if (decimalPlaces < 18) {
            long factor = Maths.tens(decimalPlaces);
            double d1 = d;
            boolean neg = d1 < 0.0;
            double df = (d1 = Math.abs(d1)) * (double)factor;
            if (df < 9.223372036854776E18) {
                long ldf = (long)df;
                double residual = df - (double)ldf + Math.ulp(d1) * ((double)factor * 0.983);
                if (residual >= 0.5) {
                    ++ldf;
                }
                if (neg) {
                    ldf = -ldf;
                }
                long round = ldf;
                if (this.canWriteDirect(20L + (long)decimalPlaces)) {
                    long address = this.addressForWritePosition();
                    long address2 = UnsafeText.appendBase10d(address, round, decimalPlaces);
                    this.writeSkip(address2 - address);
                } else {
                    this.appendDecimal(round, decimalPlaces);
                }
                return (B)this;
            }
        }
        return this.append(d);
    }

    @NotNull
    default public B append(@NotNull CharSequence cs, @NonNegative int start, @NonNegative int end) throws IndexOutOfBoundsException {
        BytesInternal.appendUtf8(this, cs, start, end - start);
        return (B)this;
    }

    @NotNull
    default public B append8bit(@NotNull CharSequence cs) throws BufferOverflowException, BufferUnderflowException, IndexOutOfBoundsException, IllegalStateException {
        try {
            return this.append8bit(cs, 0, cs.length());
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    default public B append8bit(@NotNull BytesStore bs) throws BufferOverflowException, BufferUnderflowException, IllegalStateException {
        try {
            return (B)((ByteStringAppender)this.write(bs, 0L, bs.readRemaining()));
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    default public B append8bit(@NotNull String cs) throws BufferOverflowException, IllegalStateException {
        try {
            return this.append8bit(cs, 0, cs.length());
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException | BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    default public B append8bit(@NotNull CharSequence cs, @NonNegative int start, @NonNegative int end) throws IllegalArgumentException, BufferOverflowException, BufferUnderflowException, IndexOutOfBoundsException, IllegalStateException {
        if (!1.$assertionsDisabled && end < start) {
            throw new AssertionError((Object)("end=" + end + ",start=" + start));
        }
        if (cs instanceof BytesStore) {
            return (B)((ByteStringAppender)this.write((BytesStore)cs, (long)start, (long)(end - start)));
        }
        for (int i = start; i < end; ++i) {
            int c = cs.charAt(i);
            if (c > 255) {
                c = 63;
            }
            this.writeByte((byte)c);
        }
        return (B)this;
    }

    default public B append8bit(@NotNull BytesStore bs, @NonNegative long start, @NonNegative long end) throws IllegalArgumentException, BufferOverflowException, BufferUnderflowException, IndexOutOfBoundsException, IllegalStateException {
        if (!1.$assertionsDisabled && end <= start) {
            throw new AssertionError((Object)("end=" + end + ",start=" + start));
        }
        return (B)((ByteStringAppender)this.write(bs, start, end - start));
    }

    @NotNull
    default public B appendDateMillis(long dateInMillis) throws BufferOverflowException, IllegalStateException {
        BytesInternal.appendDateMillis(this, dateInMillis);
        return (B)this;
    }

    @NotNull
    default public B appendTimeMillis(long timeOfDayInMillis) throws BufferOverflowException, IllegalStateException, IllegalArgumentException {
        BytesInternal.appendTimeMillis(this, timeOfDayInMillis % 86400000L);
        return (B)this;
    }

    @NotNull
    default public B append(@NotNull BigDecimal bigDecimal) {
        this.append(bigDecimal.toString());
        return (B)this;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

