/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.avro;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.cassandra.cdc.api.KeyspaceTypeKey;
import org.apache.cassandra.cdc.avro.AvroBaseRecordTransformer;
import org.apache.cassandra.cdc.avro.CdcEventUtils;
import org.apache.cassandra.cdc.msg.CdcEvent;
import org.apache.cassandra.cdc.schemastore.SchemaStore;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.utils.Preconditions;

public class AvroGenericRecordTransformer
extends AvroBaseRecordTransformer<GenericRecordSerializedEvent, GenericRecord> {
    final String schemaNamespacePrefix;

    public AvroGenericRecordTransformer(SchemaStore schemaStore, Function<KeyspaceTypeKey, CqlField.CqlType> typeLookup, String schemaNamespacePrefix) {
        this(schemaStore, typeLookup, 838860, schemaNamespacePrefix);
    }

    public AvroGenericRecordTransformer(SchemaStore schemaStore, Function<KeyspaceTypeKey, CqlField.CqlType> typeLookup, int truncateThreshold, String schemaNamespacePrefix) {
        super(schemaStore, typeLookup, truncateThreshold, "cdc_generic_record.avsc");
        this.schemaNamespacePrefix = schemaNamespacePrefix;
    }

    @Override
    public GenericRecordSerializedEvent serializeEvent(CdcEvent event) {
        CdcEventUtils.UpdatedEvent updatedEvent = CdcEventUtils.getUpdatedEvent(event, this.store, this.truncateThreshold, this.typeLookup);
        return new GenericRecordSerializedEvent((GenericRecord)updatedEvent.getRecord(), updatedEvent.getTruncatedFields(), event.table, event.keyspace);
    }

    @Override
    public GenericData.Record buildRecordWithPayload(GenericRecordSerializedEvent serializedEvent) {
        GenericRecord payload = (GenericRecord)serializedEvent.payload;
        Schema newSchema = this.getTempSchemaForEvent(serializedEvent);
        GenericData.Record record = new GenericData.Record(newSchema);
        record.put("payload", (Object)payload);
        return record;
    }

    public Schema getTempSchemaForEvent(GenericRecordSerializedEvent event) {
        String name = this.cdcSchema.getName();
        Object namespace = this.cdcSchema.getNamespace();
        if (!Preconditions.isNullOrEmpty((String)this.schemaNamespacePrefix)) {
            name = event.table;
            namespace = this.schemaNamespacePrefix + "." + event.keyspace;
        }
        Schema tempSchema = Schema.createRecord((String)name, (String)"schema", (String)namespace, (boolean)false);
        Schema.Field payloadField = new Schema.Field("payload", ((GenericRecord)event.payload).getSchema(), "payload");
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        for (Schema.Field f : this.cdcSchema.getFields()) {
            if (f.name().equals("payload") || f.name().equals("namespace") || f.name().equals("name")) continue;
            Schema.Field ff = new Schema.Field(f.name(), f.schema(), f.doc(), f.defaultVal());
            fields.add(ff);
        }
        fields.add(payloadField);
        tempSchema.setFields(fields);
        return tempSchema;
    }

    public static class GenericRecordSerializedEvent
    extends AvroBaseRecordTransformer.BaseSerializedEvent<GenericRecord> {
        private final String table;
        private final String keyspace;

        public GenericRecordSerializedEvent(GenericRecord payload, List<String> truncatedFields, String table, String keyspace) {
            super(payload, truncatedFields);
            this.table = table;
            this.keyspace = keyspace;
        }
    }
}

