/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.client;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import o.a.c.sidecar.client.shaded.client.RequestContext;
import o.a.c.sidecar.client.shaded.client.RequestExecutor;
import o.a.c.sidecar.client.shaded.client.SidecarClientBlobRestoreExtension;
import o.a.c.sidecar.client.shaded.client.SidecarClientConfig;
import o.a.c.sidecar.client.shaded.client.SidecarInstance;
import o.a.c.sidecar.client.shaded.client.SidecarInstancesProvider;
import o.a.c.sidecar.client.shaded.client.SimpleSidecarInstancesProvider;
import o.a.c.sidecar.client.shaded.client.StreamConsumer;
import o.a.c.sidecar.client.shaded.client.retry.CreateRestoreJobRetryPolicy;
import o.a.c.sidecar.client.shaded.client.retry.IgnoreConflictRetryPolicy;
import o.a.c.sidecar.client.shaded.client.retry.OncePerInstanceRetryPolicy;
import o.a.c.sidecar.client.shaded.client.retry.RetryPolicy;
import o.a.c.sidecar.client.shaded.client.retry.RunnableOnStatusCodeRetryPolicy;
import o.a.c.sidecar.client.shaded.client.selection.RandomInstanceSelectionPolicy;
import o.a.c.sidecar.client.shaded.common.request.AbortRestoreJobRequest;
import o.a.c.sidecar.client.shaded.common.request.AllServicesConfigRequest;
import o.a.c.sidecar.client.shaded.common.request.CreateRestoreJobRequest;
import o.a.c.sidecar.client.shaded.common.request.CreateRestoreJobSliceRequest;
import o.a.c.sidecar.client.shaded.common.request.DeleteServiceConfigRequest;
import o.a.c.sidecar.client.shaded.common.request.ImportSSTableRequest;
import o.a.c.sidecar.client.shaded.common.request.ListCdcSegmentsRequest;
import o.a.c.sidecar.client.shaded.common.request.RestoreJobProgressRequest;
import o.a.c.sidecar.client.shaded.common.request.RestoreJobSummaryRequest;
import o.a.c.sidecar.client.shaded.common.request.Service;
import o.a.c.sidecar.client.shaded.common.request.StreamCdcSegmentRequest;
import o.a.c.sidecar.client.shaded.common.request.UpdateRestoreJobRequest;
import o.a.c.sidecar.client.shaded.common.request.UpdateServiceConfigRequest;
import o.a.c.sidecar.client.shaded.common.request.data.AbortRestoreJobRequestPayload;
import o.a.c.sidecar.client.shaded.common.request.data.AllServicesConfigPayload;
import o.a.c.sidecar.client.shaded.common.request.data.CreateRestoreJobRequestPayload;
import o.a.c.sidecar.client.shaded.common.request.data.CreateSliceRequestPayload;
import o.a.c.sidecar.client.shaded.common.request.data.Digest;
import o.a.c.sidecar.client.shaded.common.request.data.RestoreJobProgressRequestParams;
import o.a.c.sidecar.client.shaded.common.request.data.UpdateCdcServiceConfigPayload;
import o.a.c.sidecar.client.shaded.common.request.data.UpdateRestoreJobRequestPayload;
import o.a.c.sidecar.client.shaded.common.response.ConnectedClientStatsResponse;
import o.a.c.sidecar.client.shaded.common.response.GossipInfoResponse;
import o.a.c.sidecar.client.shaded.common.response.HealthResponse;
import o.a.c.sidecar.client.shaded.common.response.ListCdcSegmentsResponse;
import o.a.c.sidecar.client.shaded.common.response.ListOperationalJobsResponse;
import o.a.c.sidecar.client.shaded.common.response.ListSnapshotFilesResponse;
import o.a.c.sidecar.client.shaded.common.response.NodeSettings;
import o.a.c.sidecar.client.shaded.common.response.OperationalJobResponse;
import o.a.c.sidecar.client.shaded.common.response.RingResponse;
import o.a.c.sidecar.client.shaded.common.response.SSTableImportResponse;
import o.a.c.sidecar.client.shaded.common.response.SchemaResponse;
import o.a.c.sidecar.client.shaded.common.response.StreamStatsResponse;
import o.a.c.sidecar.client.shaded.common.response.TableStatsResponse;
import o.a.c.sidecar.client.shaded.common.response.TimeSkewResponse;
import o.a.c.sidecar.client.shaded.common.response.TokenRangeReplicasResponse;
import o.a.c.sidecar.client.shaded.common.response.data.CreateRestoreJobResponsePayload;
import o.a.c.sidecar.client.shaded.common.response.data.RestoreJobProgressResponsePayload;
import o.a.c.sidecar.client.shaded.common.response.data.RestoreJobSummaryResponsePayload;
import o.a.c.sidecar.client.shaded.common.utils.HttpRange;
import o.a.c.sidecar.client.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SidecarClient
implements AutoCloseable,
SidecarClientBlobRestoreExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(SidecarClient.class);
    protected RequestExecutor executor;
    protected final RetryPolicy defaultRetryPolicy;
    protected final RetryPolicy ignoreConflictRetryPolicy;
    protected final RetryPolicy oncePerInstanceRetryPolicy;
    protected RequestContext.Builder baseBuilder;

    public SidecarClient(SidecarInstancesProvider instancesProvider, RequestExecutor requestExecutor, SidecarClientConfig sidecarClientConfig, RetryPolicy defaultRetryPolicy) {
        this.defaultRetryPolicy = defaultRetryPolicy;
        this.ignoreConflictRetryPolicy = new IgnoreConflictRetryPolicy(sidecarClientConfig.maxRetries(), sidecarClientConfig.retryDelayMillis(), sidecarClientConfig.maxRetryDelayMillis());
        this.oncePerInstanceRetryPolicy = new OncePerInstanceRetryPolicy(sidecarClientConfig.minimumHealthRetryDelay(), sidecarClientConfig.maximumHealthRetryDelay());
        this.baseBuilder = new RequestContext.Builder().instanceSelectionPolicy(new RandomInstanceSelectionPolicy(instancesProvider)).retryPolicy(defaultRetryPolicy);
        this.executor = requestExecutor;
    }

    public CompletableFuture<HealthResponse> sidecarHealth() {
        return this.executor.executeRequestAsync(this.requestBuilder().sidecarHealthRequest().retryPolicy(this.oncePerInstanceRetryPolicy).build());
    }

    public CompletableFuture<HealthResponse> sidecarHealth(SidecarInstance instance) {
        return this.executor.executeRequestAsync(this.requestBuilder().singleInstanceSelectionPolicy(instance).retryPolicy(this.oncePerInstanceRetryPolicy).sidecarHealthRequest().build());
    }

    @Deprecated
    public CompletableFuture<HealthResponse> cassandraHealth() {
        return this.executor.executeRequestAsync(this.requestBuilder().cassandraHealthRequest().retryPolicy(this.oncePerInstanceRetryPolicy).build());
    }

    public CompletableFuture<HealthResponse> cassandraNativeHealth() {
        return this.executor.executeRequestAsync(this.requestBuilder().cassandraNativeHealthRequest().retryPolicy(new OncePerInstanceRetryPolicy()).build());
    }

    public CompletableFuture<HealthResponse> cassandraJmxHealth() {
        return this.executor.executeRequestAsync(this.requestBuilder().cassandraJmxHealthRequest().retryPolicy(new OncePerInstanceRetryPolicy()).build());
    }

    public CompletableFuture<SchemaResponse> fullSchema() {
        return this.executor.executeRequestAsync(this.requestBuilder().schemaRequest().build());
    }

    public CompletableFuture<SchemaResponse> schema(String keyspace) {
        return this.executor.executeRequestAsync(this.requestBuilder().schemaRequest(keyspace).build());
    }

    public CompletableFuture<RingResponse> ring(String keyspace) {
        return this.executor.executeRequestAsync(this.requestBuilder().ringRequest(keyspace).build());
    }

    public CompletableFuture<NodeSettings> nodeSettings() {
        return this.executor.executeRequestAsync(this.requestBuilder().nodeSettingsRequest().build());
    }

    public CompletableFuture<NodeSettings> nodeSettings(SidecarInstance instance) {
        return this.executor.executeRequestAsync(this.requestBuilder().singleInstanceSelectionPolicy(instance).nodeSettingsRequest().build());
    }

    public CompletableFuture<GossipInfoResponse> gossipInfo() {
        return this.executor.executeRequestAsync(this.requestBuilder().gossipInfoRequest().build());
    }

    public CompletableFuture<HealthResponse> gossipHealth(SidecarInstance instance) {
        return this.executor.executeRequestAsync(this.requestBuilder().singleInstanceSelectionPolicy(instance).gossipHealthRequest().build());
    }

    public CompletableFuture<TimeSkewResponse> timeSkew() {
        return this.executor.executeRequestAsync(this.requestBuilder().timeSkewRequest().build());
    }

    public CompletableFuture<TimeSkewResponse> timeSkew(List<? extends SidecarInstance> instances) {
        SimpleSidecarInstancesProvider instancesProvider = new SimpleSidecarInstancesProvider(instances);
        RandomInstanceSelectionPolicy instanceSelectionPolicy = new RandomInstanceSelectionPolicy(instancesProvider);
        return this.executor.executeRequestAsync(this.requestBuilder().instanceSelectionPolicy(instanceSelectionPolicy).timeSkewRequest().build());
    }

    public CompletableFuture<TokenRangeReplicasResponse> tokenRangeReplicas(List<? extends SidecarInstance> instances, String keyspace) {
        SimpleSidecarInstancesProvider instancesProvider = new SimpleSidecarInstancesProvider(instances);
        RandomInstanceSelectionPolicy instanceSelectionPolicy = new RandomInstanceSelectionPolicy(instancesProvider);
        return this.executeRequestAsync(this.requestBuilder().instanceSelectionPolicy(instanceSelectionPolicy).tokenRangeReplicasRequest(keyspace).build());
    }

    public CompletableFuture<ListSnapshotFilesResponse> listSnapshotFiles(SidecarInstance instance, String keyspace, String table, String snapshotName) {
        return this.listSnapshotFiles(instance, keyspace, table, snapshotName, true);
    }

    public CompletableFuture<ListSnapshotFilesResponse> listSnapshotFiles(SidecarInstance instance, String keyspace, String table, String snapshotName, boolean includeSecondaryIndexFiles) {
        return this.executor.executeRequestAsync(this.requestBuilder().singleInstanceSelectionPolicy(instance).listSnapshotFilesRequest(keyspace, table, snapshotName, includeSecondaryIndexFiles).build());
    }

    public CompletableFuture<Void> clearSnapshot(SidecarInstance instance, String keyspace, String table, String snapshotName) {
        return this.executor.executeRequestAsync(this.requestBuilder().singleInstanceSelectionPolicy(instance).clearSnapshotRequest(keyspace, table, snapshotName).build());
    }

    public CompletableFuture<Void> createSnapshot(SidecarInstance instance, String keyspace, String table, String snapshotName) {
        return this.createSnapshot(instance, keyspace, table, snapshotName, null);
    }

    public CompletableFuture<Void> createSnapshot(SidecarInstance instance, String keyspace, String table, String snapshotName, @Nullable String snapshotTTL) {
        return this.executor.executeRequestAsync(this.requestBuilder().retryPolicy(this.ignoreConflictRetryPolicy).singleInstanceSelectionPolicy(instance).createSnapshotRequest(keyspace, table, snapshotName, snapshotTTL).build());
    }

    @Deprecated
    public void streamSSTableComponent(SidecarInstance instance, String keyspace, String table, String snapshotName, String componentName, HttpRange range, StreamConsumer streamConsumer) {
        this.executor.streamRequest(this.requestBuilder().singleInstanceSelectionPolicy(instance).ssTableComponentRequest(keyspace, table, snapshotName, componentName, range).build(), streamConsumer);
    }

    public void streamSSTableComponent(SidecarInstance instance, ListSnapshotFilesResponse.FileInfo fileInfo, HttpRange range, StreamConsumer streamConsumer) {
        this.executor.streamRequest(this.requestBuilder().singleInstanceSelectionPolicy(instance).ssTableComponentRequest(fileInfo, range).build(), streamConsumer);
    }

    public CompletableFuture<Void> uploadSSTableRequest(SidecarInstance instance, String keyspace, String table, String uploadId, String componentName, Digest digest, String filename) {
        return this.executor.executeRequestAsync(this.requestBuilder().singleInstanceSelectionPolicy(instance).uploadSSTableRequest(keyspace, table, uploadId, componentName, digest, filename).build());
    }

    public CompletableFuture<SSTableImportResponse> importSSTableRequest(SidecarInstance instance, String keyspace, String table, String uploadId, ImportSSTableRequest.ImportOptions options) {
        Runnable customLog = () -> LOGGER.info("Request to {} ACCEPTED but not yet complete - will retry until success/failure. uploadId={}", (Object)instance, (Object)uploadId);
        RunnableOnStatusCodeRetryPolicy retryPolicy = new RunnableOnStatusCodeRetryPolicy(customLog, this.defaultRetryPolicy, HttpResponseStatus.ACCEPTED.code(), 10);
        return this.executor.executeRequestAsync(this.requestBuilder().singleInstanceSelectionPolicy(instance).retryPolicy(retryPolicy).importSSTableRequest(keyspace, table, uploadId, options).build());
    }

    public CompletableFuture<Void> cleanUploadSession(SidecarInstance instance, String uploadId) {
        return this.executor.executeRequestAsync(this.requestBuilder().singleInstanceSelectionPolicy(instance).cleanSSTableUploadSessionRequest(uploadId).build());
    }

    public CompletableFuture<ListCdcSegmentsResponse> listCdcSegments(SidecarInstance sidecarInstance) {
        return this.executor.executeRequestAsync(this.requestBuilder().singleInstanceSelectionPolicy(sidecarInstance).request(new ListCdcSegmentsRequest()).build());
    }

    public void streamCdcSegments(SidecarInstance sidecarInstance, String segment, HttpRange range, StreamConsumer streamConsumer) {
        this.executor.streamRequest(this.requestBuilder().singleInstanceSelectionPolicy(sidecarInstance).request(new StreamCdcSegmentRequest(segment, range)).build(), streamConsumer);
    }

    public <T> CompletableFuture<T> reportSchema(SidecarInstance instance) {
        return this.executor.executeRequestAsync(this.requestBuilder().singleInstanceSelectionPolicy(instance).reportSchemaRequest().noRetryPolicy().build());
    }

    public CompletableFuture<AllServicesConfigPayload> allServicesConfig() {
        return this.executor.executeRequestAsync(this.requestBuilder().request(new AllServicesConfigRequest()).build());
    }

    public CompletableFuture<UpdateCdcServiceConfigPayload> updateCdcServiceConfig(Service service, Map<String, String> config) {
        return this.executor.executeRequestAsync(this.requestBuilder().request(new UpdateServiceConfigRequest(service, new UpdateCdcServiceConfigPayload(config))).build());
    }

    public CompletableFuture<Void> deleteCdcServiceConfig(Service service) {
        return this.executor.executeRequestAsync(this.requestBuilder().request(new DeleteServiceConfigRequest(service)).build());
    }

    @Override
    public CompletableFuture<CreateRestoreJobResponsePayload> createRestoreJob(String keyspace, String table, CreateRestoreJobRequestPayload payload) {
        Objects.requireNonNull(payload, "payload cannot be null");
        return this.executor.executeRequestAsync(this.requestBuilder().retryPolicy(new CreateRestoreJobRetryPolicy(this.defaultRetryPolicy)).request(new CreateRestoreJobRequest(keyspace, table, payload)).build());
    }

    @Override
    public CompletableFuture<Void> updateRestoreJob(String keyspace, String table, UUID jobId, UpdateRestoreJobRequestPayload payload) {
        return this.executor.executeRequestAsync(this.requestBuilder().request(new UpdateRestoreJobRequest(keyspace, table, jobId, payload)).build());
    }

    @Override
    public CompletableFuture<Void> abortRestoreJob(String keyspace, String table, UUID jobId, AbortRestoreJobRequestPayload payload) {
        return this.executor.executeRequestAsync(this.requestBuilder().request(new AbortRestoreJobRequest(keyspace, table, jobId, payload)).build());
    }

    @Override
    public CompletableFuture<RestoreJobSummaryResponsePayload> restoreJobSummary(String keyspace, String table, UUID jobId) {
        return this.executor.executeRequestAsync(this.requestBuilder().request(new RestoreJobSummaryRequest(keyspace, table, jobId)).build());
    }

    @Override
    public CompletableFuture<Void> createRestoreJobSlice(SidecarInstance instance, String keyspace, String table, UUID jobId, CreateSliceRequestPayload payload) {
        return this.executor.executeRequestAsync(this.requestBuilder().singleInstanceSelectionPolicy(instance).request(new CreateRestoreJobSliceRequest(keyspace, table, jobId, payload)).build());
    }

    @Override
    public CompletableFuture<Void> createRestoreJobSlice(String keyspace, String table, UUID jobId, CreateSliceRequestPayload payload) {
        return this.executor.executeRequestAsync(this.requestBuilder().request(new CreateRestoreJobSliceRequest(keyspace, table, jobId, payload)).build());
    }

    @Override
    public CompletableFuture<RestoreJobProgressResponsePayload> restoreJobProgress(RestoreJobProgressRequestParams params) {
        return this.executor.executeRequestAsync(this.requestBuilder().request(new RestoreJobProgressRequest(params)).build());
    }

    public CompletableFuture<ConnectedClientStatsResponse> connectedClientStats(SidecarInstance instance) {
        return this.executor.executeRequestAsync(this.requestBuilder().singleInstanceSelectionPolicy(instance).connectedClientStatsRequest().build());
    }

    public CompletableFuture<TableStatsResponse> tableStats(SidecarInstance instance, String keyspace, String table) {
        return this.executor.executeRequestAsync(this.requestBuilder().singleInstanceSelectionPolicy(instance).tableStatsRequest(keyspace, table).build());
    }

    public CompletableFuture<OperationalJobResponse> operationalJobs(SidecarInstance instance, UUID jobId) {
        return this.executor.executeRequestAsync(this.requestBuilder().singleInstanceSelectionPolicy(instance).operationalJobRequest(jobId).build());
    }

    public CompletableFuture<ListOperationalJobsResponse> listOperationalJobs(SidecarInstance instance) {
        return this.executor.executeRequestAsync(this.requestBuilder().singleInstanceSelectionPolicy(instance).listOperationalJobsRequest().build());
    }

    public CompletableFuture<StreamStatsResponse> streamsStats(SidecarInstance instance) {
        return this.executor.executeRequestAsync(this.requestBuilder().singleInstanceSelectionPolicy(instance).streamsStatsRequest().build());
    }

    public CompletableFuture<OperationalJobResponse> nodeDecommission(SidecarInstance instance) {
        return this.executor.executeRequestAsync(this.requestBuilder().singleInstanceSelectionPolicy(instance).nodeDecommissionRequest().build());
    }

    public RequestContext.Builder requestBuilder() {
        return this.baseBuilder.copy();
    }

    public RetryPolicy defaultRetryPolicy() {
        return this.defaultRetryPolicy;
    }

    public <T> CompletableFuture<T> executeRequestAsync(RequestContext context) {
        return this.executor.executeRequestAsync(context);
    }

    @Override
    public void close() throws Exception {
        this.executor.close();
    }
}

