/*
 * Decompiled with CFR 0.152.
 */
package org.github.jamm.strategies;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.github.jamm.strategies.ContendedUtils;
import org.github.jamm.strategies.ContentionGroupsCounter;
import org.github.jamm.strategies.MemoryLayoutBasedStrategy;
import org.github.jamm.utils.MathUtils;

class SpecStrategy
extends MemoryLayoutBasedStrategy {
    SpecStrategy() {
    }

    @Override
    public final long measureInstance(Object instance, Class<?> type) {
        long size = (long)MEMORY_LAYOUT.getObjectHeaderSize() + this.sizeOfDeclaredFields(type);
        while ((type = type.getSuperclass()) != Object.class && type != null) {
            size += this.sizeOfDeclaredFields(type);
        }
        return MathUtils.roundTo(size, MEMORY_LAYOUT.getObjectAlignment());
    }

    private long sizeOfDeclaredFields(Class<?> type) {
        long size = 0L;
        ContentionGroupsCounter contentionGroupCounter = null;
        for (Field f : type.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers())) continue;
            size += (long)this.measureField(f.getType());
            contentionGroupCounter = ContendedUtils.countContentionGroup(contentionGroupCounter, f);
        }
        if (ContendedUtils.isClassAnnotatedWithContended(type) && ContendedUtils.isContendedEnabled(type)) {
            size += (long)(MEMORY_LAYOUT.getContendedPaddingWidth() << 1);
        }
        if (contentionGroupCounter != null) {
            size += (long)(contentionGroupCounter.count() * (MEMORY_LAYOUT.getContendedPaddingWidth() << 1));
        }
        return size;
    }
}

