/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Ints;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.Slf4JLoggerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.net.AbstractMessageHandler;
import org.apache.cassandra.net.AsyncChannelPromise;
import org.apache.cassandra.net.BufferPoolAllocator;
import org.apache.cassandra.net.FrameDecoder;
import org.apache.cassandra.net.FrameDecoderCrc;
import org.apache.cassandra.net.FrameDecoderLZ4;
import org.apache.cassandra.net.FrameEncoder;
import org.apache.cassandra.net.FrameEncoderCrc;
import org.apache.cassandra.net.FrameEncoderLZ4;
import org.apache.cassandra.net.GlobalBufferPoolAllocator;
import org.apache.cassandra.net.ResourceLimits;
import org.apache.cassandra.security.SSLFactory;
import org.apache.cassandra.transport.CQLMessageHandler;
import org.apache.cassandra.transport.ClientResourceLimits;
import org.apache.cassandra.transport.Compressor;
import org.apache.cassandra.transport.Connection;
import org.apache.cassandra.transport.Envelope;
import org.apache.cassandra.transport.Event;
import org.apache.cassandra.transport.Flusher;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.PreV5Handlers;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.transport.messages.ErrorMessage;
import org.apache.cassandra.transport.messages.EventMessage;
import org.apache.cassandra.transport.messages.ExecuteMessage;
import org.apache.cassandra.transport.messages.PrepareMessage;
import org.apache.cassandra.transport.messages.QueryMessage;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.transport.messages.StartupMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleClient
implements Closeable {
    private static final Logger logger;
    public final String host;
    public final int port;
    private final EncryptionOptions encryptionOptions;
    private final int largeMessageThreshold;
    protected final ResponseHandler responseHandler = new ResponseHandler();
    protected final Connection.Tracker tracker = new ConnectionTracker();
    protected final ProtocolVersion version;
    protected Connection connection;
    protected Bootstrap bootstrap;
    protected Channel channel;
    protected ChannelFuture lastWriteFuture;
    protected String compression;

    public static Builder builder(String host, int port) {
        return new Builder(host, port);
    }

    private SimpleClient(Builder builder) {
        this.host = builder.host;
        this.port = builder.port;
        this.version = builder.version;
        this.encryptionOptions = builder.encryptionOptions.applyConfig();
        this.largeMessageThreshold = builder.largeMessageThreshold;
    }

    public SimpleClient(String host, int port, ProtocolVersion version, EncryptionOptions encryptionOptions) {
        this(host, port, version, false, encryptionOptions);
    }

    public SimpleClient(String host, int port, EncryptionOptions encryptionOptions) {
        this(host, port, ProtocolVersion.CURRENT, encryptionOptions);
    }

    public SimpleClient(String host, int port, ProtocolVersion version) {
        this(host, port, version, new EncryptionOptions());
    }

    public SimpleClient(String host, int port, ProtocolVersion version, boolean useBeta, EncryptionOptions encryptionOptions) {
        this.host = host;
        this.port = port;
        if (version.isBeta() && !useBeta) {
            throw new IllegalArgumentException(String.format("Beta version of server used (%s), but USE_BETA flag is not set", version));
        }
        this.version = version;
        this.encryptionOptions = new EncryptionOptions(encryptionOptions).applyConfig();
        this.largeMessageThreshold = 131072 - Math.max(10, 12);
    }

    public SimpleClient(String host, int port) {
        this(host, port, new EncryptionOptions());
    }

    public SimpleClient connect(boolean useCompression) throws IOException {
        return this.connect(useCompression, false);
    }

    public SimpleClient connect(boolean useCompression, boolean throwOnOverload) throws IOException {
        this.establishConnection();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("CQL_VERSION", "3.0.0");
        if (throwOnOverload) {
            options.put("THROW_ON_OVERLOAD", "1");
        }
        this.connection.setThrowOnOverload(throwOnOverload);
        if (useCompression) {
            options.put("COMPRESSION", "LZ4");
            this.connection.setCompressor(Compressor.LZ4Compressor.instance);
        }
        this.execute(new StartupMessage(options));
        return this;
    }

    public void setEventHandler(EventHandler eventHandler) {
        this.responseHandler.eventHandler = eventHandler;
    }

    @VisibleForTesting
    void establishConnection() throws IOException {
        this.bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)new NioEventLoopGroup((ThreadFactory)new NamedThreadFactory("SimpleClient-nioEventLoopGroup")))).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true);
        if (this.encryptionOptions.isEnabled().booleanValue()) {
            this.bootstrap.handler((ChannelHandler)new SecureInitializer(this.largeMessageThreshold));
        } else {
            this.bootstrap.handler((ChannelHandler)new Initializer(this.largeMessageThreshold));
        }
        ChannelFuture future = this.bootstrap.connect((SocketAddress)new InetSocketAddress(this.host, this.port));
        this.channel = future.awaitUninterruptibly().channel();
        if (!future.isSuccess()) {
            this.bootstrap.group().shutdownGracefully();
            throw new IOException("Connection Error", future.cause());
        }
    }

    public ResultMessage execute(String query, ConsistencyLevel consistency) {
        return this.execute(query, Collections.emptyList(), consistency);
    }

    public ResultMessage execute(String query, List<ByteBuffer> values, ConsistencyLevel consistencyLevel) {
        Message.Response msg = this.execute(new QueryMessage(query, QueryOptions.forInternalCalls(consistencyLevel, values)));
        assert (msg instanceof ResultMessage);
        return (ResultMessage)msg;
    }

    public ResultMessage.Prepared prepare(String query) {
        Message.Response msg = this.execute(new PrepareMessage(query, null));
        assert (msg instanceof ResultMessage.Prepared);
        return (ResultMessage.Prepared)msg;
    }

    public ResultMessage executePrepared(ResultMessage.Prepared prepared, List<ByteBuffer> values, ConsistencyLevel consistency) {
        Message.Response msg = this.execute(new ExecuteMessage(prepared.statementId, prepared.resultMetadataId, QueryOptions.forInternalCalls(consistency, values)));
        assert (msg instanceof ResultMessage);
        return (ResultMessage)msg;
    }

    @Override
    public void close() {
        if (this.lastWriteFuture != null) {
            this.lastWriteFuture.awaitUninterruptibly();
        }
        this.channel.close().awaitUninterruptibly();
        this.bootstrap.group().shutdownGracefully();
    }

    public Message.Response execute(Message.Request request) {
        return this.execute(request, true);
    }

    public Message.Response execute(Message.Request request, boolean throwOnErrorResponse) {
        try {
            request.attach(this.connection);
            this.lastWriteFuture = this.channel.writeAndFlush(Collections.singletonList(request));
            Message.Response msg = this.responseHandler.responses.poll(10L, TimeUnit.SECONDS);
            if (msg == null) {
                throw new RuntimeException("timeout");
            }
            if (throwOnErrorResponse && msg instanceof ErrorMessage) {
                throw new RuntimeException((Throwable)((Object)((ErrorMessage)msg).error));
            }
            return msg;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<Message.Request, Message.Response> execute(List<Message.Request> requests) {
        try {
            HashMap<Message.Request, Message.Response> rrMap = new HashMap<Message.Request, Message.Response>();
            if (this.version.isGreaterOrEqualTo(ProtocolVersion.V5)) {
                for (int i = 0; i < requests.size(); ++i) {
                    Message.Request message = requests.get(i);
                    message.setStreamId(i);
                    message.attach(this.connection);
                }
                this.lastWriteFuture = this.channel.writeAndFlush(requests);
                long deadline = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(10L);
                for (int i = 0; i < requests.size(); ++i) {
                    Message.Response msg = this.responseHandler.responses.poll(deadline - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                    if (msg == null) {
                        throw new RuntimeException("timeout");
                    }
                    if (msg instanceof ErrorMessage) {
                        throw new RuntimeException((Throwable)((Object)((ErrorMessage)msg).error));
                    }
                    rrMap.put(requests.get(msg.getStreamId()), msg);
                }
            } else {
                for (Message.Request request : requests) {
                    rrMap.put(request, this.execute(request));
                }
            }
            return rrMap;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new Slf4JLoggerFactory());
        logger = LoggerFactory.getLogger(SimpleClient.class);
    }

    public static class SimpleFlusher {
        private static final ChannelFuture[] EMPTY_FUTURES_ARRAY = new ChannelFuture[0];
        final Queue<Envelope> outbound = new ConcurrentLinkedQueue<Envelope>();
        final FrameEncoder frameEncoder;
        private final AtomicBoolean scheduled = new AtomicBoolean(false);

        SimpleFlusher(FrameEncoder frameEncoder) {
            this.frameEncoder = frameEncoder;
        }

        public void enqueue(Envelope message) {
            this.outbound.offer(message);
        }

        public void releaseAll() {
            Envelope e;
            while ((e = this.outbound.poll()) != null) {
                e.release();
            }
        }

        public void schedule(ChannelHandlerContext ctx) {
            if (this.scheduled.compareAndSet(false, true)) {
                ctx.executor().scheduleAtFixedRate(() -> this.maybeWrite(ctx, (Promise<Void>)ctx.voidPromise()), 10L, 10L, TimeUnit.MILLISECONDS);
            }
        }

        public void maybeWrite(ChannelHandlerContext ctx, Promise<Void> promise) {
            Envelope f;
            if (this.outbound.isEmpty()) {
                promise.setSuccess(null);
                return;
            }
            PromiseCombiner combiner = new PromiseCombiner(ctx.executor());
            ArrayList<Envelope> buffer = new ArrayList<Envelope>();
            long bufferSize = 0L;
            boolean pending = false;
            while ((f = this.outbound.poll()) != null) {
                if (f.header.bodySizeInBytes > (long)Flusher.MAX_FRAMED_PAYLOAD_SIZE) {
                    combiner.addAll((Future[])this.writeLargeMessage(ctx, f));
                    continue;
                }
                int messageSize = CQLMessageHandler.envelopeSize(f.header);
                if (bufferSize + (long)messageSize >= (long)Flusher.MAX_FRAMED_PAYLOAD_SIZE) {
                    logger.trace("Sending frame of size: {}", (Object)bufferSize);
                    combiner.add((Future)this.flushBuffer(ctx, buffer, bufferSize));
                    buffer = new ArrayList();
                    bufferSize = 0L;
                }
                buffer.add(f);
                bufferSize += (long)messageSize;
                pending = true;
            }
            if (pending) {
                logger.trace("Sending frame of size: {}", (Object)bufferSize);
                combiner.add((Future)this.flushBuffer(ctx, buffer, bufferSize));
            }
            combiner.finish(promise);
        }

        private ChannelFuture flushBuffer(ChannelHandlerContext ctx, List<Envelope> messages, long bufferSize) {
            FrameEncoder.Payload payload = this.allocate(Ints.checkedCast((long)bufferSize), true);
            for (Envelope e : messages) {
                e.encodeInto(payload.buffer);
            }
            payload.finish();
            AsyncChannelPromise release = AsyncChannelPromise.withListener(ctx, (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)future -> {
                logger.trace("Sent frame of size: {}", (Object)bufferSize);
                for (Envelope e : messages) {
                    e.release();
                }
            }));
            return ctx.writeAndFlush((Object)payload, (ChannelPromise)release);
        }

        private FrameEncoder.Payload allocate(int size, boolean selfContained) {
            FrameEncoder.Payload payload = this.frameEncoder.allocator().allocate(selfContained, Math.min(size, Flusher.MAX_FRAMED_PAYLOAD_SIZE));
            if (size >= Flusher.MAX_FRAMED_PAYLOAD_SIZE) {
                payload.buffer.limit(Flusher.MAX_FRAMED_PAYLOAD_SIZE);
            }
            return payload;
        }

        private ChannelFuture[] writeLargeMessage(ChannelHandlerContext ctx, Envelope f) {
            ArrayList<ChannelFuture> futures = new ArrayList<ChannelFuture>();
            boolean firstFrame = true;
            while (f.body.readableBytes() > 0 || firstFrame) {
                int remaining;
                int payloadSize = Math.min(f.body.readableBytes(), Flusher.MAX_FRAMED_PAYLOAD_SIZE);
                FrameEncoder.Payload payload = this.allocate(f.body.readableBytes(), false);
                ByteBuffer buf = payload.buffer;
                if (payloadSize >= Flusher.MAX_FRAMED_PAYLOAD_SIZE) {
                    buf.limit(Flusher.MAX_FRAMED_PAYLOAD_SIZE);
                }
                if (firstFrame) {
                    f.encodeHeaderInto(buf);
                    firstFrame = false;
                }
                if ((remaining = Math.min(buf.remaining(), f.body.readableBytes())) > 0) {
                    buf.put(f.body.slice(f.body.readerIndex(), remaining).nioBuffer());
                }
                f.body.readerIndex(f.body.readerIndex() + remaining);
                payload.finish();
                ChannelPromise promise = ctx.newPromise();
                logger.trace("Sending frame of large message: {}", (Object)remaining);
                futures.add(ctx.writeAndFlush((Object)payload, promise));
                promise.addListener(result -> {
                    if (!result.isSuccess()) {
                        logger.warn("Failed to send frame of large message, size: " + remaining, result.cause());
                    } else {
                        logger.trace("Sent frame of large message, size: {}", (Object)remaining);
                    }
                });
            }
            f.release();
            return futures.toArray(EMPTY_FUTURES_ARRAY);
        }
    }

    @ChannelHandler.Sharable
    static class ResponseHandler
    extends SimpleChannelInboundHandler<Message.Response> {
        public final BlockingQueue<Message.Response> responses = new SynchronousQueue<Message.Response>(true);
        public EventHandler eventHandler;

        ResponseHandler() {
        }

        public void channelRead0(ChannelHandlerContext ctx, Message.Response r) {
            this.handleResponse(ctx.channel(), r);
        }

        public void handleResponse(Channel channel, Message.Response r) {
            try {
                Envelope cloned = r.getSource().clone();
                r.getSource().release();
                r.setSource(cloned);
                if (r instanceof EventMessage) {
                    if (this.eventHandler != null) {
                        this.eventHandler.onEvent(((EventMessage)r).event);
                    }
                } else {
                    this.responses.put(r);
                }
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (this == ctx.pipeline().last()) {
                logger.error("Exception in response", cause);
            } else {
                ctx.fireExceptionCaught(cause);
            }
        }
    }

    private class SecureInitializer
    extends Initializer {
        SecureInitializer(int largeMessageThreshold) {
            super(largeMessageThreshold);
        }

        @Override
        protected void initChannel(Channel channel) throws Exception {
            super.initChannel(channel);
            SslContext sslContext = SSLFactory.getOrCreateSslContext(SimpleClient.this.encryptionOptions, ((SimpleClient)SimpleClient.this).encryptionOptions.require_client_auth, SSLFactory.SocketType.CLIENT);
            channel.pipeline().addFirst("ssl", (ChannelHandler)sslContext.newHandler(channel.alloc()));
        }
    }

    private class Initializer
    extends ChannelInitializer<Channel> {
        private int largeMessageThreshold;

        Initializer(int largeMessageThreshold) {
            this.largeMessageThreshold = largeMessageThreshold;
        }

        protected void initChannel(Channel channel) throws Exception {
            SimpleClient.this.connection = new Connection(channel, SimpleClient.this.version, SimpleClient.this.tracker);
            channel.attr(Connection.attributeKey).set((Object)SimpleClient.this.connection);
            ChannelPipeline pipeline = channel.pipeline();
            pipeline.addLast("envelopeDecoder", (ChannelHandler)new Envelope.Decoder());
            pipeline.addLast("envelopeEncoder", (ChannelHandler)Envelope.Encoder.instance);
            pipeline.addLast("intitialHandler", (ChannelHandler)new InitialHandler(SimpleClient.this.version, SimpleClient.this.responseHandler, this.largeMessageThreshold));
            pipeline.addLast("messageDecoder", (ChannelHandler)PreV5Handlers.ProtocolDecoder.instance);
            pipeline.addLast("messageEncoder", (ChannelHandler)MessageBatchEncoder.instance);
            pipeline.addLast("responseHandler", (ChannelHandler)SimpleClient.this.responseHandler);
        }
    }

    @ChannelHandler.Sharable
    static class MessageBatchEncoder
    extends MessageToMessageEncoder<List<Message>> {
        public static final MessageBatchEncoder instance = new MessageBatchEncoder();

        private MessageBatchEncoder() {
        }

        public void encode(ChannelHandlerContext ctx, List<Message> messages, List<Object> results) {
            ProtocolVersion version;
            Connection connection = (Connection)ctx.channel().attr(Connection.attributeKey).get();
            ProtocolVersion protocolVersion = version = connection == null ? ProtocolVersion.CURRENT : connection.getVersion();
            assert (messages.size() == 1);
            results.add(messages.get(0).encode(version));
        }
    }

    private static class InitialHandler
    extends MessageToMessageDecoder<Envelope> {
        final ProtocolVersion version;
        final ResponseHandler responseHandler;
        final int largeMessageThreshold;

        InitialHandler(ProtocolVersion version, ResponseHandler responseHandler, int largeMessageThreshold) {
            this.version = version;
            this.responseHandler = responseHandler;
            this.largeMessageThreshold = largeMessageThreshold;
        }

        protected void decode(ChannelHandlerContext ctx, Envelope response, List<Object> results) {
            switch (response.header.type) {
                case READY: 
                case AUTHENTICATE: {
                    if (response.header.version.isGreaterOrEqualTo(ProtocolVersion.V5)) {
                        this.configureModernPipeline(ctx, response);
                        break;
                    }
                    this.configureLegacyPipeline(ctx);
                    ctx.pipeline().context(Envelope.Decoder.class).fireChannelRead((Object)response);
                    break;
                }
                case SUPPORTED: {
                    results.add(response);
                    break;
                }
                default: {
                    throw new ProtocolException(String.format("Unexpected %s response expecting READY, AUTHENTICATE or SUPPORTED", new Object[]{response.header.type}));
                }
            }
        }

        private void configureModernPipeline(ChannelHandlerContext ctx, Envelope response) {
            logger.info("Configuring modern pipeline");
            ChannelPipeline pipeline = ctx.pipeline();
            pipeline.remove("envelopeDecoder");
            pipeline.remove("messageDecoder");
            pipeline.remove("messageEncoder");
            pipeline.remove("responseHandler");
            GlobalBufferPoolAllocator allocator = GlobalBufferPoolAllocator.instance;
            Channel channel = ctx.channel();
            channel.config().setOption(ChannelOption.ALLOCATOR, (Object)allocator);
            int queueCapacity = 0x100000;
            Envelope.Decoder envelopeDecoder = new Envelope.Decoder();
            Message.Decoder<Message.Response> messageDecoder = Message.responseDecoder();
            FrameDecoder frameDecoder = this.frameDecoder(ctx, allocator);
            final FrameEncoder frameEncoder = this.frameEncoder(ctx);
            FrameEncoder.PayloadAllocator payloadAllocator = frameEncoder.allocator();
            CQLMessageHandler.MessageConsumer<Message.Response> responseConsumer = (c, message, converter) -> this.responseHandler.handleResponse(c, (Message.Response)message);
            CQLMessageHandler.ErrorHandler errorHandler = error -> {
                throw new RuntimeException("Unexpected error", error);
            };
            ClientResourceLimits.ResourceProvider resources = new ClientResourceLimits.ResourceProvider(){
                final ResourceLimits.Limit endpointReserve = new ResourceLimits.Basic(0x4000000L);
                final AbstractMessageHandler.WaitQueue endpointQueue = AbstractMessageHandler.WaitQueue.endpoint(this.endpointReserve);
                final ResourceLimits.Limit globalReserve = new ResourceLimits.Basic(0x4000000L);
                final AbstractMessageHandler.WaitQueue globalQueue = AbstractMessageHandler.WaitQueue.global(this.endpointReserve);

                @Override
                public ResourceLimits.Limit globalLimit() {
                    return this.globalReserve;
                }

                @Override
                public AbstractMessageHandler.WaitQueue globalWaitQueue() {
                    return this.globalQueue;
                }

                @Override
                public ResourceLimits.Limit endpointLimit() {
                    return this.endpointReserve;
                }

                @Override
                public AbstractMessageHandler.WaitQueue endpointWaitQueue() {
                    return this.endpointQueue;
                }

                @Override
                public void release() {
                }
            };
            CQLMessageHandler<Message.Response> processor = new CQLMessageHandler<Message.Response>(ctx.channel(), this.version, frameDecoder, envelopeDecoder, messageDecoder, responseConsumer, payloadAllocator, queueCapacity, resources, handler -> {}, errorHandler, ((Connection)ctx.channel().attr(Connection.attributeKey).get()).isThrowOnOverload()){

                @Override
                protected boolean processRequest(Envelope request) {
                    boolean continueProcessing = super.processRequest(request);
                    this.releaseCapacity(Ints.checkedCast((long)request.header.bodySizeInBytes));
                    return continueProcessing;
                }
            };
            pipeline.addLast("frameDecoder", (ChannelHandler)frameDecoder);
            pipeline.addLast("frameEncoder", (ChannelHandler)frameEncoder);
            pipeline.addLast("processor", (ChannelHandler)processor);
            pipeline.addLast("messageEncoder", (ChannelHandler)new ChannelOutboundHandlerAdapter(){

                public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                    if (!(msg instanceof List)) {
                        ctx.write(msg, promise);
                        return;
                    }
                    Connection connection = (Connection)ctx.channel().attr(Connection.attributeKey).get();
                    ProtocolVersion version = connection == null ? ProtocolVersion.CURRENT : connection.getVersion();
                    SimpleFlusher flusher = new SimpleFlusher(frameEncoder);
                    for (Message message : (List)msg) {
                        flusher.enqueue(message.encode(version));
                    }
                    flusher.maybeWrite(ctx, (Promise<Void>)promise);
                }
            });
            pipeline.remove((ChannelHandler)this);
            Message.Response message2 = messageDecoder.decode(ctx.channel(), response);
            responseConsumer.accept(channel, message2, (ch, req, resp) -> null);
        }

        private FrameDecoder frameDecoder(ChannelHandlerContext ctx, BufferPoolAllocator allocator) {
            Connection conn = (Connection)ctx.channel().attr(Connection.attributeKey).get();
            if (conn.getCompressor() == null) {
                return FrameDecoderCrc.create(allocator);
            }
            if (conn.getCompressor() instanceof Compressor.LZ4Compressor) {
                return FrameDecoderLZ4.fast(allocator);
            }
            throw new ProtocolException("Unsupported compressor: " + conn.getCompressor().getClass().getCanonicalName());
        }

        private FrameEncoder frameEncoder(ChannelHandlerContext ctx) {
            Connection conn = (Connection)ctx.channel().attr(Connection.attributeKey).get();
            if (conn.getCompressor() == null) {
                return FrameEncoderCrc.instance;
            }
            if (conn.getCompressor() instanceof Compressor.LZ4Compressor) {
                return FrameEncoderLZ4.fastInstance;
            }
            throw new ProtocolException("Unsupported compressor: " + conn.getCompressor().getClass().getCanonicalName());
        }

        private void configureLegacyPipeline(ChannelHandlerContext ctx) {
            logger.info("Configuring legacy pipeline");
            ChannelPipeline pipeline = ctx.pipeline();
            pipeline.remove((ChannelHandler)this);
            pipeline.addAfter("envelopeEncoder", "decompressor", (ChannelHandler)Envelope.Decompressor.instance);
            pipeline.addAfter("decompressor", "compressor", (ChannelHandler)Envelope.Compressor.instance);
        }
    }

    private static class HandlerNames {
        private static final String ENVELOPE_DECODER = "envelopeDecoder";
        private static final String ENVELOPE_ENCODER = "envelopeEncoder";
        private static final String COMPRESSOR = "compressor";
        private static final String DECOMPRESSOR = "decompressor";
        private static final String MESSAGE_DECODER = "messageDecoder";
        private static final String MESSAGE_ENCODER = "messageEncoder";
        private static final String INITIAL_HANDLER = "intitialHandler";
        private static final String RESPONSE_HANDLER = "responseHandler";
        private static final String FRAME_DECODER = "frameDecoder";
        private static final String FRAME_ENCODER = "frameEncoder";
        private static final String PROCESSOR = "processor";

        private HandlerNames() {
        }
    }

    private static class ConnectionTracker
    implements Connection.Tracker {
        private ConnectionTracker() {
        }

        @Override
        public void addConnection(Channel ch, Connection connection) {
        }
    }

    public static class SimpleEventHandler
    implements EventHandler {
        public final LinkedBlockingQueue<Event> queue = new LinkedBlockingQueue();

        @Override
        public void onEvent(Event event) {
            this.queue.add(event);
        }
    }

    public static interface EventHandler {
        public void onEvent(Event var1);
    }

    public static class Builder {
        private final String host;
        private final int port;
        private EncryptionOptions encryptionOptions = new EncryptionOptions();
        private ProtocolVersion version = ProtocolVersion.CURRENT;
        private boolean useBeta = false;
        private int largeMessageThreshold = 131072;

        private Builder(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public Builder encryption(EncryptionOptions options) {
            this.encryptionOptions = options;
            return this;
        }

        public Builder useBeta() {
            this.useBeta = true;
            return this;
        }

        public Builder protocolVersion(ProtocolVersion version) {
            this.version = version;
            return this;
        }

        public Builder largeMessageThreshold(int bytes) {
            this.largeMessageThreshold = bytes;
            return this;
        }

        public SimpleClient build() {
            if (this.version.isBeta() && !this.useBeta) {
                throw new IllegalArgumentException(String.format("Beta version of server used (%s), but USE_BETA flag is not set", this.version));
            }
            return new SimpleClient(this);
        }
    }
}

