/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.perf.test.basic;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.perf.test.BasicState;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;

public class BytesTest {
    @Benchmark
    @OperationsPerInvocation(value=10000)
    public void encode(TestStateEncode state) throws Exception {
        Encoder e = state.encoder;
        for (int i = 0; i < state.getBatchSize(); i += 4) {
            e.writeBytes(state.testData[i + 0]);
            e.writeBytes(state.testData[i + 1]);
            e.writeBytes(state.testData[i + 2]);
            e.writeBytes(state.testData[i + 3]);
        }
    }

    @Benchmark
    @OperationsPerInvocation(value=10000)
    public ByteBuffer decode(TestStateDecode state) throws Exception {
        Decoder d = state.decoder;
        for (int i = 0; i < state.getBatchSize(); i += 4) {
            d.readBytes(state.bb);
            d.readBytes(state.bb);
            d.readBytes(state.bb);
            d.readBytes(state.bb);
        }
        return state.bb;
    }

    @State(value=Scope.Thread)
    public static class TestStateDecode
    extends BasicState {
        private byte[] testData;
        private Decoder decoder;
        private ByteBuffer bb = ByteBuffer.allocate(70);

        @Setup(value=Level.Trial)
        public void doSetupTrial() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Encoder encoder = super.newEncoder(true, (OutputStream)baos);
            for (int i = 0; i < this.getBatchSize(); ++i) {
                byte[] data = new byte[super.getRandom().nextInt(70)];
                super.getRandom().nextBytes(data);
                encoder.writeBytes(data);
            }
            this.testData = baos.toByteArray();
        }

        @Setup(value=Level.Invocation)
        public void doSetupInvocation() throws Exception {
            this.decoder = super.newDecoder(this.testData);
        }
    }

    @State(value=Scope.Thread)
    public static class TestStateEncode
    extends BasicState {
        private byte[][] testData;
        private Encoder encoder;

        @Setup(value=Level.Trial)
        public void doSetupTrial() throws Exception {
            this.encoder = super.newEncoder(false, this.getNullOutputStream());
            this.testData = new byte[this.getBatchSize()][];
            for (int i = 0; i < this.testData.length; ++i) {
                byte[] data = new byte[super.getRandom().nextInt(70)];
                super.getRandom().nextBytes(data);
                this.testData[i] = data;
            }
        }
    }
}

