/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.bridge;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.config.TransformerConfiguration;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.Match;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgePolicy;
import org.apache.qpid.proton.amqp.Symbol;

public final class AMQPBridgeAddressPolicy
extends AMQPBridgePolicy
implements BiPredicate<String, RoutingType> {
    private final Set<AddressMatcher> includesMatchers = new LinkedHashSet<AddressMatcher>();
    private final Set<AddressMatcher> excludesMatchers = new LinkedHashSet<AddressMatcher>();
    private final Collection<String> includes;
    private final Collection<String> excludes;
    private final boolean includeDivertBindings;
    private final boolean useDurableSubscriptions;

    public AMQPBridgeAddressPolicy(String policyName, boolean includeDivertBindings, boolean useDurableSubscriptions, Integer priority, String filter, String remoteAddress, String remoteAddressPrefix, String remoteAddressSuffix, Collection<Symbol> remoteTerminusCapabilities, Collection<String> includeAddresses, Collection<String> excludeAddresses, Map<String, Object> properties, TransformerConfiguration transformerConfig, WildcardConfiguration wildcardConfig) {
        super(policyName, priority, filter, remoteAddress, remoteAddressPrefix, remoteAddressSuffix, remoteTerminusCapabilities, properties, transformerConfig, wildcardConfig);
        this.includeDivertBindings = includeDivertBindings;
        this.useDurableSubscriptions = useDurableSubscriptions;
        this.includes = Collections.unmodifiableCollection(Objects.requireNonNullElse(includeAddresses, Collections.emptyList()));
        this.excludes = Collections.unmodifiableCollection(Objects.requireNonNullElse(excludeAddresses, Collections.emptyList()));
        this.includes.forEach(address -> this.includesMatchers.add(new AddressMatcher((String)address, wildcardConfig)));
        this.excludes.forEach(address -> this.excludesMatchers.add(new AddressMatcher((String)address, wildcardConfig)));
    }

    public boolean isIncludeDivertBindings() {
        return this.includeDivertBindings;
    }

    public boolean isUseDurableSubscriptions() {
        return this.useDurableSubscriptions;
    }

    public boolean test(AddressInfo addressInfo) {
        if (addressInfo != null) {
            return this.test(addressInfo.getName().toString(), addressInfo.getRoutingType());
        }
        return false;
    }

    @Override
    public boolean test(String address, RoutingType type) {
        if (RoutingType.MULTICAST.equals((Object)type)) {
            for (AddressMatcher matcher : this.excludesMatchers) {
                if (!matcher.test(address)) continue;
                return false;
            }
            for (AddressMatcher matcher : this.includesMatchers) {
                if (!matcher.test(address)) continue;
                return true;
            }
        }
        return false;
    }

    private static class AddressMatcher
    implements Predicate<String> {
        private final Predicate<String> matcher;

        AddressMatcher(String address, WildcardConfiguration wildcardConfig) {
            this.matcher = address == null || address.isEmpty() ? target -> true : new Match(address, null, wildcardConfig).getPattern().asPredicate();
        }

        @Override
        public boolean test(String address) {
            return this.matcher.test(address);
        }
    }
}

