-- SchemaCrawler
-- http://www.schemacrawler.com
-- Copyright (c) 2000-2026, Sualeh Fatehi <sualeh@hotmail.com>.
-- All rights reserved.
-- SPDX-License-Identifier: EPL-2.0

SELECT
  NULLIF(1, 1) AS CONSTRAINT_CATALOG,
  STRIP(SYSIBM.TABLE_CONSTRAINTS.CONSTRAINT_SCHEMA) AS CONSTRAINT_SCHEMA,
  STRIP(SYSIBM.TABLE_CONSTRAINTS.CONSTRAINT_NAME) AS CONSTRAINT_NAME,
  NULLIF(1, 1) AS TABLE_CATALOG,
  STRIP(SYSIBM.TABLE_CONSTRAINTS.TABLE_SCHEMA) AS TABLE_SCHEMA,
  STRIP(SYSIBM.TABLE_CONSTRAINTS.TABLE_NAME) AS TABLE_NAME,
  STRIP(SYSIBM.TABLE_CONSTRAINTS.CONSTRAINT_TYPE) AS CONSTRAINT_TYPE,
  STRIP(SYSIBM.TABLE_CONSTRAINTS.IS_DEFERRABLE) AS IS_DEFERRABLE,
  STRIP(SYSIBM.TABLE_CONSTRAINTS.INITIALLY_DEFERRED) AS INITIALLY_DEFERRED
FROM
  SYSIBM.TABLE_CONSTRAINTS
ORDER BY
  SYSIBM.TABLE_CONSTRAINTS.TABLE_SCHEMA,
  SYSIBM.TABLE_CONSTRAINTS.TABLE_NAME
WITH UR  
