-- SchemaCrawler
-- http://www.schemacrawler.com
-- Copyright (c) 2000-2026, Sualeh Fatehi <sualeh@hotmail.com>.
-- All rights reserved.
-- SPDX-License-Identifier: EPL-2.0

SELECT
  NULL AS FUNCTION_CAT,
  FUNCTIONS.OWNER AS FUNCTION_SCHEM,
  FUNCTIONS.OBJECT_NAME AS FUNCTION_NAME,
  FUNCTIONS.OBJECT_NAME AS SPECIFIC_NAME,
  CASE WHEN ARGUMENTS.OBJECT_ID IS NULL
    THEN 0
    ELSE 1
  END AS FUNCTION_TYPE,
  NULL AS REMARKS
FROM
  ${catalogscope}_PROCEDURES FUNCTIONS
  LEFT OUTER JOIN ${catalogscope}_ARGUMENTS ARGUMENTS
    ON FUNCTIONS.OBJECT_ID = ARGUMENTS.OBJECT_ID
      AND ARGUMENTS.ARGUMENT_NAME IS NULL
      AND ARGUMENTS.POSITION = 0
  INNER JOIN ${catalogscope}_USERS USERS
    ON FUNCTIONS.OWNER = USERS.USERNAME
      AND USERS.ORACLE_MAINTAINED = 'N'
      AND NOT REGEXP_LIKE(USERS.USERNAME, '^APEX_[0-9]{6}$')
      AND NOT REGEXP_LIKE(USERS.USERNAME, '^FLOWS_[0-9]{5}$')
      AND NOT REGEXP_LIKE(USERS.USERNAME, '^OPS\$ORACLE$')
WHERE
  REGEXP_LIKE(FUNCTIONS.OWNER, '${schema-inclusion-rule}')
  AND FUNCTIONS.OBJECT_TYPE = 'FUNCTION'
ORDER BY
  FUNCTION_SCHEM,
  FUNCTION_NAME
